/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.myfaces.tobago.event.SheetAction;
import org.apache.myfaces.tobago.internal.component.AbstractUIPaginator;
import org.apache.myfaces.tobago.internal.component.AbstractUIPaginatorList;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.renderkit.renderer.PaginatorRenderer;
import org.apache.myfaces.tobago.layout.Arrows;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatorListRenderer<T extends AbstractUIPaginatorList>
extends PaginatorRenderer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T paginator) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = paginator.getClientId(facesContext);
        AbstractUISheet sheet = ((AbstractUIPaginator)paginator).getPageable();
        boolean visible = ((AbstractUIPaginator)paginator).isAlwaysVisible() || sheet.needMoreThanOnePage();
        writer.startElement(HtmlElements.TOBAGO_PAGINATOR_LIST);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(visible ? null : BootstrapClass.D_NONE, paginator.getCustomClass());
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeIdAttribute(((AbstractUIPaginator)paginator).getFieldId(facesContext));
        writer.writeNameAttribute(clientId);
        writer.endElement(HtmlElements.INPUT);
        if (sheet != null) {
            int skip;
            writer.startElement(HtmlElements.UL);
            writer.writeClassAttribute(BootstrapClass.PAGINATION);
            int linkCount = ((AbstractUIPaginatorList)paginator).getMax();
            ArrayList<Integer> prevs = new ArrayList<Integer>(--linkCount);
            int page = sheet.getCurrentPage() + 1;
            for (int i = 0; i < linkCount && page > 1; ++i) {
                if (--page <= 0) continue;
                prevs.add(0, page);
            }
            ArrayList<Integer> nexts = new ArrayList<Integer>(linkCount);
            page = sheet.getCurrentPage() + 1;
            int pages = sheet.hasRowCount() || sheet.isRowsUnlimited() ? sheet.getPages() : Integer.MAX_VALUE;
            for (int i = 0; i < linkCount && page < pages; ++i) {
                if (++page <= 1) continue;
                nexts.add(page);
            }
            if (prevs.size() > linkCount / 2 && nexts.size() > linkCount - linkCount / 2) {
                while (prevs.size() > linkCount / 2) {
                    prevs.remove(0);
                }
                while (nexts.size() > linkCount - linkCount / 2) {
                    nexts.remove(nexts.size() - 1);
                }
            } else if (prevs.size() <= linkCount / 2) {
                while (prevs.size() + nexts.size() > linkCount) {
                    nexts.remove(nexts.size() - 1);
                }
            } else {
                while (prevs.size() + nexts.size() > linkCount) {
                    prevs.remove(0);
                }
            }
            Arrows arrows = ((AbstractUIPaginatorList)paginator).getArrows();
            boolean atBeginning = sheet.isAtBeginning();
            if (arrows == Arrows.show || arrows == Arrows.auto && !atBeginning) {
                this.encodeLink(facesContext, atBeginning, SheetAction.first, null, Icons.SKIP_START, null);
                this.encodeLink(facesContext, atBeginning, SheetAction.prev, null, Icons.CARET_LEFT, null);
            }
            int n = skip = !prevs.isEmpty() ? (Integer)prevs.get(0) : 1;
            if (arrows != Arrows.show && arrows != Arrows.auto && skip > 1) {
                skip -= linkCount - linkCount / 2;
                if (--skip < 1) {
                    skip = 1;
                }
                this.encodeLink(facesContext, false, SheetAction.toPage, skip, Icons.THREE_DOTS, null);
            }
            for (Integer prev : prevs) {
                this.encodeLink(facesContext, false, SheetAction.toPage, prev, null, null);
            }
            this.encodeLink(facesContext, false, SheetAction.toPage, sheet.getCurrentPage() + 1, null, BootstrapClass.ACTIVE);
            for (Integer next : nexts) {
                this.encodeLink(facesContext, false, SheetAction.toPage, next, null, null);
            }
            int n2 = skip = !nexts.isEmpty() ? (Integer)nexts.get(nexts.size() - 1) : pages;
            if (arrows != Arrows.show && arrows != Arrows.auto && skip < pages) {
                skip += linkCount / 2;
                if (++skip > pages) {
                    skip = pages;
                }
                this.encodeLink(facesContext, false, SheetAction.toPage, skip, Icons.THREE_DOTS, null);
            }
            boolean atEnd = sheet.isAtEnd();
            if (arrows == Arrows.show || arrows == Arrows.auto && !atEnd) {
                this.encodeLink(facesContext, atEnd, SheetAction.next, null, Icons.CARET_RIGHT, null);
                this.encodeLink(facesContext, atEnd || !sheet.hasRowCount(), SheetAction.last, null, Icons.SKIP_END, null);
            }
            writer.endElement(HtmlElements.UL);
        } else {
            LOG.warn("No sheet found for paginator with clientId='{}'!", (Object)clientId);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_PAGINATOR_LIST);
    }
}

