/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.Rule;

public abstract class HeaderRule
extends Rule {
    private String _headerName;
    private String _headerValue;

    public String getHeaderName() {
        return this._headerName;
    }

    public void setHeaderName(String header) {
        this._headerName = header;
    }

    public String getHeaderValue() {
        return this._headerValue;
    }

    public void setHeaderValue(String headerValue) {
        this._headerValue = headerValue;
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        String value = input.getHeaders().get(this.getHeaderName());
        if (value == null) {
            return null;
        }
        String headerValue = this.getHeaderValue();
        if (headerValue == null || headerValue.equals(value)) {
            return this.apply(input, value);
        }
        return null;
    }

    protected abstract Rule.Handler apply(Rule.Handler var1, String var2) throws IOException;

    @Override
    public String toString() {
        return "%s[header:%s=%s]".formatted(super.toString(), this.getHeaderName(), this.getHeaderValue());
    }
}

