/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariablePerform is an enum
type OpcuaNodeIdServicesVariablePerform int32

type IOpcuaNodeIdServicesVariablePerform interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariablePerform_PerformUpdateType_EnumValues OpcuaNodeIdServicesVariablePerform = 11885
)

var OpcuaNodeIdServicesVariablePerformValues []OpcuaNodeIdServicesVariablePerform

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariablePerformValues = []OpcuaNodeIdServicesVariablePerform{
		OpcuaNodeIdServicesVariablePerform_PerformUpdateType_EnumValues,
	}
}

func OpcuaNodeIdServicesVariablePerformByValue(value int32) (enum OpcuaNodeIdServicesVariablePerform, ok bool) {
	switch value {
	case 11885:
		return OpcuaNodeIdServicesVariablePerform_PerformUpdateType_EnumValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePerformByName(value string) (enum OpcuaNodeIdServicesVariablePerform, ok bool) {
	switch value {
	case "PerformUpdateType_EnumValues":
		return OpcuaNodeIdServicesVariablePerform_PerformUpdateType_EnumValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePerformKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariablePerformValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariablePerform(structType any) OpcuaNodeIdServicesVariablePerform {
	castFunc := func(typ any) OpcuaNodeIdServicesVariablePerform {
		if sOpcuaNodeIdServicesVariablePerform, ok := typ.(OpcuaNodeIdServicesVariablePerform); ok {
			return sOpcuaNodeIdServicesVariablePerform
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariablePerform) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariablePerform) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariablePerformParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariablePerform, error) {
	return OpcuaNodeIdServicesVariablePerformParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariablePerformParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariablePerform, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariablePerform", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariablePerform")
	}
	if enum, ok := OpcuaNodeIdServicesVariablePerformByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariablePerform")
		return OpcuaNodeIdServicesVariablePerform(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariablePerform) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariablePerform) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariablePerform", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariablePerform) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariablePerform) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariablePerform_PerformUpdateType_EnumValues:
		return "PerformUpdateType_EnumValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariablePerform) String() string {
	return e.PLC4XEnumName()
}
