/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.watcher.ResourceWatcher;

public abstract class AbstractResourceWatcher<Listener>
implements ResourceWatcher {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private boolean initialized = false;

    @Override
    public void init() throws IOException {
        if (!this.initialized) {
            this.doInit();
            this.initialized = true;
        }
    }

    @Override
    public void checkAndNotify() throws IOException {
        this.init();
        this.doCheckAndNotify();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    protected List<Listener> listeners() {
        return this.listeners;
    }

    protected abstract void doInit() throws IOException;

    protected abstract void doCheckAndNotify() throws IOException;
}

