/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.AsyncRpcApi;
import org.apache.ratis.client.DataStreamClient;
import org.apache.ratis.client.DataStreamClientRpc;
import org.apache.ratis.client.DataStreamOutputRpc;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.client.impl.OrderedStreamAsync;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.impl.DataStreamPacketByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.io.FilePositionCount;
import org.apache.ratis.io.StandardWriteOption;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SlidingWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamClientImpl
implements DataStreamClient {
    public static final Logger LOG = LoggerFactory.getLogger(DataStreamClientImpl.class);
    private final RaftClient client;
    private final ClientId clientId;
    private final RaftGroupId groupId;
    private final RaftPeer dataStreamServer;
    private final DataStreamClientRpc dataStreamClientRpc;
    private final OrderedStreamAsync orderedStreamAsync;
    private final boolean skipSendForward;

    DataStreamClientImpl(ClientId clientId, RaftGroupId groupId, RaftPeer dataStreamServer, DataStreamClientRpc dataStreamClientRpc, RaftProperties properties) {
        this.skipSendForward = RaftConfigKeys.DataStream.skipSendForward((RaftProperties)properties, arg_0 -> ((Logger)LOG).info(arg_0));
        this.client = null;
        this.clientId = clientId;
        this.groupId = groupId;
        this.dataStreamServer = dataStreamServer;
        this.dataStreamClientRpc = dataStreamClientRpc;
        this.orderedStreamAsync = new OrderedStreamAsync(dataStreamClientRpc, properties);
    }

    DataStreamClientImpl(RaftClient client, RaftPeer dataStreamServer, DataStreamClientRpc dataStreamClientRpc, RaftProperties properties) {
        this.skipSendForward = RaftConfigKeys.DataStream.skipSendForward((RaftProperties)properties, arg_0 -> ((Logger)LOG).info(arg_0));
        this.client = client;
        this.clientId = client.getId();
        this.groupId = client.getGroupId();
        this.dataStreamServer = dataStreamServer;
        this.dataStreamClientRpc = dataStreamClientRpc;
        this.orderedStreamAsync = new OrderedStreamAsync(dataStreamClientRpc, properties);
    }

    @Override
    public DataStreamClientRpc getClientRpc() {
        return this.dataStreamClientRpc;
    }

    @Override
    public DataStreamOutputImpl stream(RaftClientRequest request) {
        return new DataStreamOutputImpl(request);
    }

    @Override
    public DataStreamOutputRpc stream(ByteBuffer headerMessage) {
        return this.stream(headerMessage, null);
    }

    @Override
    public DataStreamOutputRpc stream(ByteBuffer headerMessage, RoutingTable routingTable) {
        if (routingTable != null) {
            Preconditions.assertTrue((boolean)this.dataStreamServer.getId().equals((Object)routingTable.getPrimary()), () -> "Primary peer mismatched: the routing table has " + routingTable.getPrimary() + " but the client has " + this.dataStreamServer.getId());
        }
        Message message = Optional.ofNullable(headerMessage).map(ByteString::copyFrom).map(Message::valueOf).orElse(null);
        RaftClientRequest request = RaftClientRequest.newBuilder().setClientId(this.clientId).setServerId(this.dataStreamServer.getId()).setGroupId(this.groupId).setCallId(CallId.getAndIncrement()).setMessage(message).setType(RaftClientRequest.dataStreamRequestType()).setRoutingTable(routingTable).build();
        return new DataStreamOutputImpl(request);
    }

    @Override
    public void close() throws IOException {
        this.dataStreamClientRpc.close();
    }

    public final class DataStreamOutputImpl
    implements DataStreamOutputRpc {
        private final RaftClientRequest header;
        private final CompletableFuture<DataStreamReply> headerFuture;
        private final SlidingWindow.Client<OrderedStreamAsync.DataStreamWindowRequest, DataStreamReply> slidingWindow;
        private final CompletableFuture<RaftClientReply> raftClientReplyFuture = new CompletableFuture();
        private CompletableFuture<DataStreamReply> closeFuture;
        private final MemoizedSupplier<WritableByteChannel> writableByteChannelSupplier = JavaUtils.memoize(() -> new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                int remaining = src.remaining();
                DataStreamReply reply = (DataStreamReply)IOUtils.getFromFuture(DataStreamOutputImpl.this.writeAsync(src, new WriteOption[]{StandardWriteOption.FLUSH}), () -> "write(" + remaining + " bytes for " + ClientInvocationId.valueOf((RaftClientMessage)DataStreamOutputImpl.this.header) + ")");
                return Math.toIntExact(reply.getBytesWritten());
            }

            @Override
            public boolean isOpen() {
                return !DataStreamOutputImpl.this.isClosed();
            }

            @Override
            public void close() throws IOException {
                if (DataStreamOutputImpl.this.isClosed()) {
                    return;
                }
                IOUtils.getFromFuture(DataStreamOutputImpl.this.writeAsync(DataStreamPacketByteBuffer.EMPTY_BYTE_BUFFER, new WriteOption[]{StandardWriteOption.CLOSE}), () -> "close(" + ClientInvocationId.valueOf((RaftClientMessage)DataStreamOutputImpl.this.header) + ")");
            }
        });
        private long streamOffset = 0L;

        private DataStreamOutputImpl(RaftClientRequest request) {
            this.header = request;
            this.slidingWindow = new SlidingWindow.Client((Object)ClientInvocationId.valueOf((ClientId)DataStreamClientImpl.this.clientId, (long)this.header.getCallId()));
            ByteBuffer buffer = ClientProtoUtils.toRaftClientRequestProtoByteBuffer(this.header);
            this.headerFuture = this.send(RaftProtos.DataStreamPacketHeaderProto.Type.STREAM_HEADER, buffer, buffer.remaining(), Collections.singleton(StandardWriteOption.FLUSH));
        }

        private CompletableFuture<DataStreamReply> send(RaftProtos.DataStreamPacketHeaderProto.Type type, Object data, long length, Iterable<WriteOption> options) {
            DataStreamRequestHeader h = new DataStreamRequestHeader(this.header.getClientId(), type, this.header.getCallId(), this.streamOffset, length, options);
            return DataStreamClientImpl.this.orderedStreamAsync.sendRequest(h, data, this.slidingWindow);
        }

        private CompletableFuture<DataStreamReply> combineHeader(CompletableFuture<DataStreamReply> future) {
            return future.thenCombine(this.headerFuture, (reply, headerReply) -> headerReply.isSuccess() ? reply : headerReply);
        }

        private CompletableFuture<DataStreamReply> writeAsyncImpl(Object data, long length, Iterable<WriteOption> options) {
            if (this.isClosed()) {
                if (data instanceof ByteBuf) {
                    ((ByteBuf)data).release();
                }
                return JavaUtils.completeExceptionally((Throwable)new AlreadyClosedException(DataStreamClientImpl.this.clientId + ": stream already closed, request=" + this.header));
            }
            CompletableFuture<DataStreamReply> f = this.combineHeader(this.send(RaftProtos.DataStreamPacketHeaderProto.Type.STREAM_DATA, data, length, options));
            if (WriteOption.containsOption(options, (WriteOption)StandardWriteOption.CLOSE)) {
                this.closeFuture = DataStreamClientImpl.this.skipSendForward ? f : (DataStreamClientImpl.this.client != null ? f.thenCompose(this::sendForward) : f);
                ((CompletableFuture)this.closeFuture.thenApply(ClientProtoUtils::getRaftClientReply)).whenComplete(JavaUtils.asBiConsumer(this.raftClientReplyFuture));
            }
            this.streamOffset += length;
            return f;
        }

        public CompletableFuture<DataStreamReply> writeAsync(ByteBuf src, Iterable<WriteOption> options) {
            return this.writeAsyncImpl(src, src.readableBytes(), options);
        }

        @Override
        public CompletableFuture<DataStreamReply> writeAsync(ByteBuffer src, Iterable<WriteOption> options) {
            return this.writeAsyncImpl(src, src.remaining(), options);
        }

        @Override
        public CompletableFuture<DataStreamReply> writeAsync(FilePositionCount src, WriteOption ... options) {
            return this.writeAsyncImpl(src, src.getCount(), Arrays.asList(options));
        }

        boolean isClosed() {
            return this.closeFuture != null;
        }

        public CompletableFuture<DataStreamReply> closeAsync() {
            if (!this.isClosed()) {
                this.writeAsync(DataStreamPacketByteBuffer.EMPTY_BYTE_BUFFER, new WriteOption[]{StandardWriteOption.CLOSE});
            }
            return Objects.requireNonNull(this.closeFuture, "closeFuture == null");
        }

        public RaftClientRequest getHeader() {
            return this.header;
        }

        @Override
        public CompletableFuture<DataStreamReply> getHeaderFuture() {
            return this.headerFuture;
        }

        @Override
        public CompletableFuture<RaftClientReply> getRaftClientReplyFuture() {
            return this.raftClientReplyFuture;
        }

        @Override
        public WritableByteChannel getWritableByteChannel() {
            return (WritableByteChannel)this.writableByteChannelSupplier.get();
        }

        private CompletableFuture<DataStreamReply> sendForward(DataStreamReply writeReply) {
            LOG.debug("sendForward {}", (Object)writeReply);
            if (!writeReply.isSuccess()) {
                return CompletableFuture.completedFuture(writeReply);
            }
            AsyncRpcApi asyncRpc = (AsyncRpcApi)DataStreamClientImpl.this.client.async();
            return asyncRpc.sendForward(this.header).thenApply(clientReply -> DataStreamReplyByteBuffer.newBuilder().setClientId(DataStreamClientImpl.this.clientId).setType(writeReply.getType()).setStreamId(writeReply.getStreamId()).setStreamOffset(writeReply.getStreamOffset()).setBuffer(ClientProtoUtils.toRaftClientReplyProto(clientReply).toByteString().asReadOnlyByteBuffer()).setSuccess(clientReply.isSuccess()).setBytesWritten(writeReply.getBytesWritten()).setCommitInfos(clientReply.getCommitInfos()).build());
        }
    }
}

