/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.sysmessage;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.admin.AdminService;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.proxy.service.route.TopicRouteService;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;

public abstract class AbstractSystemMessageSyncer
implements StartAndShutdown,
MessageListenerConcurrently {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final TopicRouteService topicRouteService;
    protected final AdminService adminService;
    protected final MQClientAPIFactory mqClientAPIFactory;
    protected final RPCHook rpcHook;
    protected DefaultMQPushConsumer defaultMQPushConsumer;

    public AbstractSystemMessageSyncer(TopicRouteService topicRouteService, AdminService adminService, MQClientAPIFactory mqClientAPIFactory, RPCHook rpcHook) {
        this.topicRouteService = topicRouteService;
        this.adminService = adminService;
        this.mqClientAPIFactory = mqClientAPIFactory;
        this.rpcHook = rpcHook;
    }

    protected String getSystemMessageProducerId() {
        return "PID_" + this.getBroadcastTopicName();
    }

    protected String getSystemMessageConsumerId() {
        return "CID_" + this.getBroadcastTopicName();
    }

    protected String getBroadcastTopicName() {
        return ConfigurationManager.getProxyConfig().getHeartbeatSyncerTopicName();
    }

    protected String getSubTag() {
        return "*";
    }

    protected String getBroadcastTopicClusterName() {
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        return proxyConfig.getHeartbeatSyncerTopicClusterName();
    }

    protected int getBroadcastTopicQueueNum() {
        return 1;
    }

    public RPCHook getRpcHook() {
        return this.rpcHook;
    }

    protected void sendSystemMessage(Object data) {
        String targetTopic = this.getBroadcastTopicName();
        try {
            Message message = new Message(targetTopic, JSON.toJSONString((Object)data).getBytes(StandardCharsets.UTF_8));
            AddressableMessageQueue messageQueue = this.topicRouteService.getAllMessageQueueView(ProxyContext.createForInner(this.getClass()), targetTopic).getWriteSelector().selectOne(true);
            this.mqClientAPIFactory.getClient().sendMessageAsync(messageQueue.getBrokerAddr(), messageQueue.getBrokerName(), message, this.buildSendMessageRequestHeader(message, this.getSystemMessageProducerId(), messageQueue.getQueueId()), Duration.ofSeconds(3L).toMillis()).whenCompleteAsync((result, throwable) -> {
                if (throwable != null) {
                    log.error("send system message failed. data: {}, topic: {}", new Object[]{data, this.getBroadcastTopicName(), throwable});
                    return;
                }
                if (SendStatus.SEND_OK != result.getSendStatus()) {
                    log.error("send system message failed. data: {}, topic: {}, sendResult:{}", new Object[]{data, this.getBroadcastTopicName(), result});
                }
            });
        }
        catch (Throwable t) {
            log.error("send system message failed. data: {}, topic: {}", new Object[]{data, targetTopic, t});
        }
    }

    protected SendMessageRequestHeader buildSendMessageRequestHeader(Message message, String producerGroup, int queueId) {
        SendMessageRequestHeader requestHeader = new SendMessageRequestHeader();
        requestHeader.setProducerGroup(producerGroup);
        requestHeader.setTopic(message.getTopic());
        requestHeader.setDefaultTopic("TBW102");
        requestHeader.setDefaultTopicQueueNums(Integer.valueOf(0));
        requestHeader.setQueueId(Integer.valueOf(queueId));
        requestHeader.setSysFlag(Integer.valueOf(0));
        requestHeader.setBornTimestamp(Long.valueOf(System.currentTimeMillis()));
        requestHeader.setFlag(Integer.valueOf(message.getFlag()));
        requestHeader.setProperties(MessageDecoder.messageProperties2String((Map)message.getProperties()));
        requestHeader.setReconsumeTimes(Integer.valueOf(0));
        requestHeader.setBatch(Boolean.valueOf(false));
        return requestHeader;
    }

    public void start() throws Exception {
        this.createSysTopic();
        RPCHook rpcHook = this.getRpcHook();
        this.defaultMQPushConsumer = new DefaultMQPushConsumer(this.getSystemMessageConsumerId(), rpcHook);
        this.defaultMQPushConsumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
        this.defaultMQPushConsumer.setMessageModel(MessageModel.BROADCASTING);
        try {
            this.defaultMQPushConsumer.subscribe(this.getBroadcastTopicName(), this.getSubTag());
        }
        catch (MQClientException e) {
            throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "subscribe to broadcast topic " + this.getBroadcastTopicName() + " failed. " + e.getMessage());
        }
        this.defaultMQPushConsumer.registerMessageListener((MessageListenerConcurrently)this);
        this.defaultMQPushConsumer.start();
    }

    protected void createSysTopic() {
        if (this.adminService.topicExist(this.getBroadcastTopicName())) {
            return;
        }
        String clusterName = this.getBroadcastTopicClusterName();
        if (StringUtils.isEmpty((CharSequence)clusterName)) {
            throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "system topic cluster cannot be empty");
        }
        boolean createSuccess = this.adminService.createTopicOnTopicBrokerIfNotExist(this.getBroadcastTopicName(), clusterName, this.getBroadcastTopicQueueNum(), this.getBroadcastTopicQueueNum(), true, 3);
        if (!createSuccess) {
            throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "create system broadcast topic " + this.getBroadcastTopicName() + " failed on cluster " + clusterName);
        }
    }

    public void shutdown() throws Exception {
        this.defaultMQPushConsumer.shutdown();
    }
}

