/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopLongHistogram;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.core.MessageStoreFetcher;
import org.apache.rocketmq.tieredstore.core.MessageStoreFetcherImpl;
import org.apache.rocketmq.tieredstore.file.FlatFileStore;
import org.apache.rocketmq.tieredstore.file.FlatMessageFile;
import org.apache.rocketmq.tieredstore.metadata.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TieredStoreMetricsManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static Supplier<AttributesBuilder> attributesBuilderSupplier;
    private static String storageMedium;
    public static LongHistogram apiLatency;
    public static LongHistogram providerRpcLatency;
    public static LongHistogram uploadBytes;
    public static LongHistogram downloadBytes;
    public static ObservableLongGauge dispatchBehind;
    public static ObservableLongGauge dispatchLatency;
    public static LongCounter messagesDispatchTotal;
    public static LongCounter messagesOutTotal;
    public static LongCounter fallbackTotal;
    public static ObservableLongGauge cacheCount;
    public static ObservableLongGauge cacheBytes;
    public static LongCounter cacheAccess;
    public static LongCounter cacheHit;
    public static ObservableLongGauge storageSize;
    public static ObservableLongGauge storageMessageReserveTime;

    public static List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        ArrayList<Pair<InstrumentSelector, ViewBuilder>> res = new ArrayList<Pair<InstrumentSelector, ViewBuilder>>();
        InstrumentSelector providerRpcLatencySelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_tiered_store_provider_rpc_latency").build();
        InstrumentSelector rpcLatencySelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_tiered_store_api_latency").build();
        ViewBuilder rpcLatencyViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(Arrays.asList(1.0, 3.0, 5.0, 7.0, 10.0, 100.0, 200.0, 400.0, 600.0, 800.0, 1000.0, 1500.0, 3000.0))).setDescription("tiered_store_rpc_latency_view");
        InstrumentSelector uploadBufferSizeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_tiered_store_provider_upload_bytes").build();
        InstrumentSelector downloadBufferSizeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_tiered_store_provider_download_bytes").build();
        ViewBuilder bufferSizeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(Arrays.asList(1024.0, 10240.0, 102400.0, 1048576.0, 1.048576E7, 3.3554432E7, 5.24288E7, 1.048576E8))).setDescription("tiered_store_buffer_size_view");
        res.add(new Pair((Object)rpcLatencySelector, (Object)rpcLatencyViewBuilder));
        res.add(new Pair((Object)providerRpcLatencySelector, (Object)rpcLatencyViewBuilder));
        res.add(new Pair((Object)uploadBufferSizeSelector, (Object)bufferSizeViewBuilder));
        res.add(new Pair((Object)downloadBufferSizeSelector, (Object)bufferSizeViewBuilder));
        return res;
    }

    public static void setStorageMedium(String storageMedium) {
        TieredStoreMetricsManager.storageMedium = storageMedium;
    }

    public static void init(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier, MessageStoreConfig storeConfig, MessageStoreFetcher fetcher, FlatFileStore flatFileStore, MessageStore next) {
        TieredStoreMetricsManager.attributesBuilderSupplier = attributesBuilderSupplier;
        apiLatency = meter.histogramBuilder("rocketmq_tiered_store_api_latency").setDescription("Tiered store rpc latency").setUnit("milliseconds").ofLongs().build();
        providerRpcLatency = meter.histogramBuilder("rocketmq_tiered_store_provider_rpc_latency").setDescription("Tiered store rpc latency").setUnit("milliseconds").ofLongs().build();
        uploadBytes = meter.histogramBuilder("rocketmq_tiered_store_provider_upload_bytes").setDescription("Tiered store upload buffer size").setUnit("bytes").ofLongs().build();
        downloadBytes = meter.histogramBuilder("rocketmq_tiered_store_provider_download_bytes").setDescription("Tiered store download buffer size").setUnit("bytes").ofLongs().build();
        dispatchBehind = meter.gaugeBuilder("rocketmq_tiered_store_dispatch_behind").setDescription("Tiered store dispatch behind message count").ofLongs().buildWithCallback(measurement -> {
            for (FlatMessageFile flatFile : flatFileStore.deepCopyFlatFileToList()) {
                MessageQueue mq = flatFile.getMessageQueue();
                long maxOffset = next.getMaxOffsetInQueue(mq.getTopic(), mq.getQueueId());
                long maxTimestamp = next.getMessageStoreTimeStamp(mq.getTopic(), mq.getQueueId(), maxOffset - 1L);
                if (maxTimestamp > 0L && System.currentTimeMillis() - maxTimestamp > TimeUnit.HOURS.toMillis(flatFile.getFileReservedHours())) continue;
                Attributes commitLogAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
                Attributes consumeQueueAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", FileSegmentType.CONSUME_QUEUE.name().toLowerCase()).build();
                measurement.record(Math.max(maxOffset - flatFile.getConsumeQueueMaxOffset(), 0L), consumeQueueAttributes);
            }
        });
        dispatchLatency = meter.gaugeBuilder("rocketmq_tiered_store_dispatch_latency").setDescription("Tiered store dispatch latency").setUnit("seconds").ofLongs().buildWithCallback(measurement -> {
            for (FlatMessageFile flatFile : flatFileStore.deepCopyFlatFileToList()) {
                MessageQueue mq = flatFile.getMessageQueue();
                long maxOffset = next.getMaxOffsetInQueue(mq.getTopic(), mq.getQueueId());
                long maxTimestamp = next.getMessageStoreTimeStamp(mq.getTopic(), mq.getQueueId(), maxOffset - 1L);
                if (maxTimestamp > 0L && System.currentTimeMillis() - maxTimestamp > TimeUnit.HOURS.toMillis(flatFile.getFileReservedHours())) continue;
                Attributes commitLogAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
                Attributes consumeQueueAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", FileSegmentType.CONSUME_QUEUE.name().toLowerCase()).build();
                long consumeQueueDispatchOffset = flatFile.getConsumeQueueMaxOffset();
                long consumeQueueDispatchLatency = next.getMessageStoreTimeStamp(mq.getTopic(), mq.getQueueId(), consumeQueueDispatchOffset);
                if (maxOffset <= consumeQueueDispatchOffset || consumeQueueDispatchLatency < 0L) {
                    measurement.record(0L, consumeQueueAttributes);
                    continue;
                }
                measurement.record(System.currentTimeMillis() - consumeQueueDispatchLatency, consumeQueueAttributes);
            }
        });
        messagesDispatchTotal = meter.counterBuilder("rocketmq_tiered_store_messages_dispatch_total").setDescription("Total number of dispatch messages").build();
        messagesOutTotal = meter.counterBuilder("rocketmq_tiered_store_messages_out_total").setDescription("Total number of outgoing messages").build();
        fallbackTotal = meter.counterBuilder("rocketmq_tiered_store_get_message_fallback_total").setDescription("Total times of fallback to next store when getting message").build();
        cacheCount = meter.gaugeBuilder("rocketmq_tiered_store_read_ahead_cache_count").setDescription("Tiered store cache message count").ofLongs().buildWithCallback(measurement -> {
            if (fetcher instanceof MessageStoreFetcherImpl) {
                long count = ((MessageStoreFetcherImpl)fetcher).getFetcherCache().stats().loadCount();
                measurement.record(count, TieredStoreMetricsManager.newAttributesBuilder().build());
            }
        });
        cacheBytes = meter.gaugeBuilder("rocketmq_tiered_store_read_ahead_cache_bytes").setDescription("Tiered store cache message bytes").setUnit("bytes").ofLongs().buildWithCallback(measurement -> {
            if (fetcher instanceof MessageStoreFetcherImpl) {
                long count = ((MessageStoreFetcherImpl)fetcher).getFetcherCache().estimatedSize();
                measurement.record(count, TieredStoreMetricsManager.newAttributesBuilder().build());
            }
        });
        cacheAccess = meter.counterBuilder("rocketmq_tiered_store_read_ahead_cache_access_total").setDescription("Tiered store cache access count").build();
        cacheHit = meter.counterBuilder("rocketmq_tiered_store_read_ahead_cache_hit_total").setDescription("Tiered store cache hit count").build();
        storageSize = meter.gaugeBuilder("rocketmq_storage_size").setDescription("Broker storage size").setUnit("bytes").ofLongs().buildWithCallback(measurement -> {
            HashMap<String, Map> topicFileSizeMap = new HashMap<String, Map>();
            try {
                MetadataStore metadataStore = flatFileStore.getMetadataStore();
                metadataStore.iterateFileSegment(fileSegment -> {
                    Map subMap = topicFileSizeMap.computeIfAbsent(fileSegment.getPath(), k -> new HashMap());
                    FileSegmentType fileSegmentType = FileSegmentType.valueOf(fileSegment.getType());
                    Long size = subMap.computeIfAbsent(fileSegmentType, k -> 0L);
                    subMap.put(fileSegmentType, size + fileSegment.getSize());
                });
            }
            catch (Exception e) {
                log.error("Failed to get storage size", (Throwable)e);
            }
            topicFileSizeMap.forEach((topic, subMap) -> subMap.forEach((fileSegmentType, size) -> {
                Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", topic).put("file_type", fileSegmentType.name().toLowerCase()).build();
                measurement.record(size.longValue(), attributes);
            }));
        });
        storageMessageReserveTime = meter.gaugeBuilder("rocketmq_storage_message_reserve_time").setDescription("Broker message reserve time").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> {
            for (FlatMessageFile flatFile : flatFileStore.deepCopyFlatFileToList()) {
                long timestamp = flatFile.getMinStoreTimestamp();
                if (timestamp <= 0L) continue;
                MessageQueue mq = flatFile.getMessageQueue();
                Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).build();
                measurement.record(System.currentTimeMillis() - timestamp, attributes);
            }
        });
    }

    public static AttributesBuilder newAttributesBuilder() {
        AttributesBuilder builder = attributesBuilderSupplier != null ? attributesBuilderSupplier.get() : Attributes.builder();
        return builder.put("storage_type", "tiered").put("storage_medium", storageMedium);
    }

    static {
        storageMedium = "blob";
        apiLatency = new NopLongHistogram();
        providerRpcLatency = new NopLongHistogram();
        uploadBytes = new NopLongHistogram();
        downloadBytes = new NopLongHistogram();
        dispatchBehind = new NopObservableLongGauge();
        dispatchLatency = new NopObservableLongGauge();
        messagesDispatchTotal = new NopLongCounter();
        messagesOutTotal = new NopLongCounter();
        fallbackTotal = new NopLongCounter();
        cacheCount = new NopObservableLongGauge();
        cacheBytes = new NopObservableLongGauge();
        cacheAccess = new NopLongCounter();
        cacheHit = new NopLongCounter();
        storageSize = new NopObservableLongGauge();
        storageMessageReserveTime = new NopObservableLongGauge();
    }
}

