/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import java.time.Duration;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.offset.BroadcastOffsetStore;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.store.exception.ConsumeQueueException;

public class BroadcastOffsetManager
extends ServiceThread {
    private static final String TOPIC_GROUP_SEPARATOR = "@";
    private final BrokerController brokerController;
    private final BrokerConfig brokerConfig;
    protected final ConcurrentHashMap<String, BroadcastOffsetData> offsetStoreMap = new ConcurrentHashMap();

    public BroadcastOffsetManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.brokerConfig = brokerController.getBrokerConfig();
    }

    public void updateOffset(String topic, String group, int queueId, long offset, String clientId, boolean fromProxy) {
        BroadcastOffsetData broadcastOffsetData = this.offsetStoreMap.computeIfAbsent(this.buildKey(topic, group), key -> new BroadcastOffsetData(topic, group));
        broadcastOffsetData.clientOffsetStore.compute(clientId, (clientIdKey, broadcastTimedOffsetStore) -> {
            if (broadcastTimedOffsetStore == null) {
                broadcastTimedOffsetStore = new BroadcastTimedOffsetStore(fromProxy);
            }
            ((BroadcastTimedOffsetStore)broadcastTimedOffsetStore).timestamp = System.currentTimeMillis();
            ((BroadcastTimedOffsetStore)broadcastTimedOffsetStore).fromProxy = fromProxy;
            ((BroadcastTimedOffsetStore)broadcastTimedOffsetStore).offsetStore.updateOffset(queueId, offset, true);
            return broadcastTimedOffsetStore;
        });
    }

    public Long queryInitOffset(String topic, String groupId, int queueId, String clientId, long requestOffset, boolean fromProxy) throws ConsumeQueueException {
        BroadcastOffsetData broadcastOffsetData = this.offsetStoreMap.get(this.buildKey(topic, groupId));
        if (broadcastOffsetData == null) {
            if (fromProxy && requestOffset < 0L) {
                return this.getOffset(null, topic, groupId, queueId);
            }
            return -1L;
        }
        AtomicLong offset = new AtomicLong(-1L);
        BroadcastTimedOffsetStore offsetStore = (BroadcastTimedOffsetStore)broadcastOffsetData.clientOffsetStore.get(clientId);
        if (offsetStore == null) {
            offsetStore = new BroadcastTimedOffsetStore(fromProxy);
            broadcastOffsetData.clientOffsetStore.put(clientId, offsetStore);
        }
        if (offsetStore.fromProxy && requestOffset < 0L) {
            offset.set(this.getOffset(offsetStore, topic, groupId, queueId));
        } else if (offsetStore.fromProxy != fromProxy) {
            offset.set(this.getOffset(offsetStore, topic, groupId, queueId));
        }
        return offset.get();
    }

    private long getOffset(BroadcastTimedOffsetStore offsetStore, String topic, String groupId, int queueId) throws ConsumeQueueException {
        long storeOffset = -1L;
        if (offsetStore != null) {
            storeOffset = offsetStore.offsetStore.readOffset(queueId);
        }
        if (storeOffset < 0L) {
            storeOffset = this.brokerController.getConsumerOffsetManager().queryOffset(BroadcastOffsetManager.broadcastGroupId(groupId), topic, queueId);
        }
        if (storeOffset < 0L) {
            storeOffset = this.brokerController.getMessageStore().checkInMemByConsumeOffset(topic, queueId, 0L, 1) ? 0L : this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId, true);
        }
        return storeOffset;
    }

    protected void scanOffsetData() {
        for (String k : this.offsetStoreMap.keySet()) {
            BroadcastOffsetData broadcastOffsetData = this.offsetStoreMap.get(k);
            if (broadcastOffsetData == null) continue;
            HashMap<Integer, Long> queueMinOffset = new HashMap<Integer, Long>();
            for (String clientId : broadcastOffsetData.clientOffsetStore.keySet()) {
                broadcastOffsetData.clientOffsetStore.computeIfPresent(clientId, (clientIdKey, broadcastTimedOffsetStore) -> {
                    boolean clientIsOnline;
                    long interval = System.currentTimeMillis() - ((BroadcastTimedOffsetStore)broadcastTimedOffsetStore).timestamp;
                    boolean bl = clientIsOnline = this.brokerController.getConsumerManager().findChannel(broadcastOffsetData.group, clientId) != null;
                    if (clientIsOnline || interval < Duration.ofSeconds(this.brokerConfig.getBroadcastOffsetExpireSecond()).toMillis()) {
                        Set<Integer> queueSet = ((BroadcastTimedOffsetStore)broadcastTimedOffsetStore).offsetStore.queueList();
                        for (Integer queue : queueSet) {
                            long offset = ((BroadcastTimedOffsetStore)broadcastTimedOffsetStore).offsetStore.readOffset(queue);
                            offset = Math.min(queueMinOffset.getOrDefault(queue, offset), offset);
                            queueMinOffset.put(queue, offset);
                        }
                    }
                    if (clientIsOnline && interval >= Duration.ofSeconds(this.brokerConfig.getBroadcastOffsetExpireMaxSecond()).toMillis()) {
                        return null;
                    }
                    if (!clientIsOnline && interval >= Duration.ofSeconds(this.brokerConfig.getBroadcastOffsetExpireSecond()).toMillis()) {
                        return null;
                    }
                    return broadcastTimedOffsetStore;
                });
            }
            this.offsetStoreMap.computeIfPresent(k, (key, broadcastOffsetDataVal) -> {
                if (((BroadcastOffsetData)broadcastOffsetDataVal).clientOffsetStore.isEmpty()) {
                    return null;
                }
                return broadcastOffsetDataVal;
            });
            queueMinOffset.forEach((queueId, offset) -> this.brokerController.getConsumerOffsetManager().commitOffset("BroadcastOffset", BroadcastOffsetManager.broadcastGroupId(broadcastOffsetData.group), broadcastOffsetData.topic, (int)queueId, (long)offset));
        }
    }

    private String buildKey(String topic, String group) {
        return topic + TOPIC_GROUP_SEPARATOR + group;
    }

    private static String broadcastGroupId(String group) {
        return group + TOPIC_GROUP_SEPARATOR + "broadcast";
    }

    public String getServiceName() {
        return "BroadcastOffsetManager";
    }

    public void run() {
        while (!this.isStopped()) {
            this.waitForRunning(Duration.ofSeconds(5L).toMillis());
        }
    }

    protected void onWaitEnd() {
        this.scanOffsetData();
    }

    public static class BroadcastTimedOffsetStore {
        private volatile long timestamp = System.currentTimeMillis();
        private volatile boolean fromProxy;
        private final BroadcastOffsetStore offsetStore;

        public BroadcastTimedOffsetStore(boolean fromProxy) {
            this.fromProxy = fromProxy;
            this.offsetStore = new BroadcastOffsetStore();
        }
    }

    public static class BroadcastOffsetData {
        private final String topic;
        private final String group;
        private final ConcurrentHashMap<String, BroadcastTimedOffsetStore> clientOffsetStore;

        public BroadcastOffsetData(String topic, String group) {
            this.topic = topic;
            this.group = group;
            this.clientOffsetStore = new ConcurrentHashMap();
        }
    }
}

