/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.log;

import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.storage.impl.RocksDBLogStorage;
import com.alipay.sofa.jraft.storage.log.LibC;
import com.alipay.sofa.jraft.util.Bits;
import com.alipay.sofa.jraft.util.BufferUtils;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Utils;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentFile
implements Lifecycle<SegmentFileOptions> {
    private static final int FSYNC_COST_MS_THRESHOLD = 1000;
    private static final int ONE_MINUTE = 60000;
    public static final int HEADER_SIZE = 18;
    private static final long BLANK_LOG_INDEX = -99L;
    private static final int BLANK_HOLE_SIZE = 64;
    private static final Logger LOG = LoggerFactory.getLogger(SegmentFile.class);
    private static final int RECORD_DATA_LENGTH_SIZE = 4;
    public static final byte[] RECORD_MAGIC_BYTES = new byte[]{87, -118};
    public static final int RECORD_MAGIC_BYTES_SIZE = RECORD_MAGIC_BYTES.length;
    private final SegmentHeader header;
    private volatile long lastLogIndex = Long.MAX_VALUE;
    private int size;
    private final String path;
    private MappedByteBuffer buffer;
    private volatile int wrotePos;
    private volatile int committedPos;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final ThreadPoolExecutor writeExecutor;
    private volatile boolean swappedOut;
    private volatile boolean readOnly;
    private long swappedOutTimestamp = -1L;
    private final String filename;
    private static MethodHandle ADDRESS_METHOD = null;

    public SegmentFile(int size, String path, ThreadPoolExecutor writeExecutor) {
        this.header = new SegmentHeader();
        this.size = size;
        this.writeExecutor = writeExecutor;
        this.path = path;
        this.filename = FilenameUtils.getName((String)this.path);
        this.readOnly = false;
        this.swappedOut = false;
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    void setFirstLogIndex(long index) {
        this.header.firstLogIndex = index;
    }

    long getLastLogIndex() {
        return this.lastLogIndex;
    }

    @OnlyForTest
    public int getWrotePos() {
        return this.wrotePos;
    }

    int getCommittedPos() {
        return this.committedPos;
    }

    String getFilename() {
        return this.filename;
    }

    long getFirstLogIndex() {
        return this.header.firstLogIndex;
    }

    public boolean isSwappedOut() {
        return this.swappedOut;
    }

    int getSize() {
        return this.size;
    }

    boolean isBlank() {
        return this.header.firstLogIndex == -99L;
    }

    boolean isHeaderCorrupted() {
        return this.header == null;
    }

    String getPath() {
        return this.path;
    }

    public void setLastLogIndex(long lastLogIndex) {
        this.writeLock.lock();
        try {
            this.lastLogIndex = lastLogIndex;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void swapIn() {
        if (this.swappedOut) {
            this.writeLock.lock();
            try {
                if (!this.swappedOut) {
                    return;
                }
                long startMs = Utils.monotonicMs();
                this.mmapFile(false);
                this.swappedOut = false;
                LOG.info("Swapped in segment file {} cost {} ms.", (Object)this.path, (Object)(Utils.monotonicMs() - startMs));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private Pointer getPointer() {
        if (ADDRESS_METHOD != null) {
            try {
                long address = ADDRESS_METHOD.invoke(this.buffer);
                Pointer pointer = new Pointer(address);
                return pointer;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void hintLoad() {
        Pointer pointer = this.getPointer();
        if (pointer != null) {
            long beginTime = Utils.monotonicMs();
            int ret = LibC.INSTANCE.madvise(pointer, new NativeLong((long)this.size), 3);
            LOG.info("madvise(MADV_WILLNEED) {} {} {} ret = {} time consuming = {}", new Object[]{pointer, this.path, this.size, ret, Utils.monotonicMs() - beginTime});
        }
    }

    public void hintUnload() {
        Pointer pointer = this.getPointer();
        if (pointer != null) {
            long beginTime = Utils.monotonicMs();
            int ret = LibC.INSTANCE.madvise(pointer, new NativeLong((long)this.size), 4);
            LOG.info("madvise(MADV_DONTNEED) {} {} {} ret = {} time consuming = {}", new Object[]{pointer, this.path, this.size, ret, Utils.monotonicMs() - beginTime});
        }
    }

    public void swapOut() {
        if (!this.swappedOut) {
            this.writeLock.lock();
            try {
                if (this.swappedOut) {
                    return;
                }
                if (!this.readOnly) {
                    LOG.warn("The segment file {} is not readonly, can't be swapped out.", (Object)this.path);
                    return;
                }
                long now = Utils.monotonicMs();
                if (this.swappedOutTimestamp > 0L && now - this.swappedOutTimestamp < 60000L) {
                    return;
                }
                this.swappedOut = true;
                Utils.unmap(this.buffer);
                this.buffer = null;
                this.swappedOutTimestamp = now;
                LOG.info("Swapped out segment file {} cost {} ms.", (Object)this.path, (Object)(Utils.monotonicMs() - now));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateSuffix(int wrotePos, long logIndex, boolean sync) {
        this.writeLock.lock();
        try {
            if (wrotePos >= this.wrotePos) {
                return;
            }
            this.swapInIfNeed();
            int oldPos = this.wrotePos;
            this.clear(wrotePos, sync);
            this.wrotePos = wrotePos;
            this.lastLogIndex = logIndex;
            BufferUtils.position(this.buffer, wrotePos);
            LOG.info("Segment file {} truncate suffix from pos={}, then set lastLogIndex={}, oldWrotePos={}, newWrotePos={}", new Object[]{this.path, wrotePos, logIndex, oldPos, this.wrotePos});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long logIndex) {
        this.readLock.lock();
        try {
            boolean bl = logIndex >= this.header.firstLogIndex && logIndex <= this.lastLogIndex;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int startPos, boolean sync) {
        this.writeLock.lock();
        try {
            if (startPos < 0 || startPos > this.size) {
                return;
            }
            int endPos = Math.min(this.size, startPos + 64);
            for (int i = startPos; i < endPos; ++i) {
                this.buffer.put(i, (byte)0);
            }
            if (sync) {
                this.fsync(this.buffer);
            }
            LOG.info("Segment file {} cleared data in [{}, {}).", new Object[]{this.path, startPos, endPos});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean init(SegmentFileOptions opts) {
        if (opts.isNewFile) {
            return this.loadNewFile(opts);
        }
        return this.loadExistsFile(opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean loadNewFile(SegmentFileOptions opts) {
        assert (opts.pos == 0);
        assert (!opts.recover);
        File file = new File(this.path);
        if (file.exists()) {
            LOG.error("File {} already exists.", (Object)this.path);
            return false;
        }
        long startMs = Utils.monotonicMs();
        this.writeLock.lock();
        try {
            boolean bl;
            Throwable throwable;
            FileChannel fc;
            block21: {
                block22: {
                    fc = this.openFileChannel(true);
                    throwable = null;
                    this.buffer = fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
                    BufferUtils.position(this.buffer, 0);
                    BufferUtils.limit(this.buffer, this.size);
                    this.saveHeader(true);
                    this.wrotePos = 18;
                    this.committedPos = 18;
                    BufferUtils.position(this.buffer, this.wrotePos);
                    assert (this.wrotePos == this.buffer.position());
                    LOG.info("Created a new segment file {} cost {} ms, wrotePosition={}, bufferPosition={}, mappedSize={}.", new Object[]{this.path, Utils.monotonicMs() - startMs, this.wrotePos, this.buffer.position(), this.size});
                    bl = true;
                    if (fc == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        fc.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                fc.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (fc != null) {
                            if (throwable != null) {
                                try {
                                    fc.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                fc.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    LOG.error("Fail to init segment file {}.", (Object)this.path, (Object)e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean loadExistsFile(SegmentFileOptions opts) {
        this.writeLock.lock();
        try {
            if (!this.mmapFile(false)) {
                boolean bl = false;
                return bl;
            }
            if (!this.tryRecoverExistsFile(opts)) {
                boolean bl = false;
                return bl;
            }
            this.readOnly = !opts.isLastFile;
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean tryRecoverExistsFile(SegmentFileOptions opts) {
        try {
            if (this.isBlank()) {
                assert (!opts.recover);
                this.wrotePos = 18;
                this.committedPos = 18;
                BufferUtils.position(this.buffer, this.wrotePos);
                LOG.info("Segment file {} is blank, truncate it from {}.", (Object)this.path, (Object)18);
                this.clear(this.wrotePos, opts.sync);
            } else {
                if (opts.recover) {
                    if (!this.recover(opts)) {
                        return false;
                    }
                } else {
                    this.wrotePos = opts.pos;
                    BufferUtils.position(this.buffer, this.wrotePos);
                }
                assert (this.wrotePos == this.buffer.position());
                this.committedPos = this.wrotePos;
            }
            LOG.info("Loaded segment file {}, wrotePosition={}, bufferPosition={}, mappedSize={}.", new Object[]{this.path, this.wrotePos, this.buffer.position(), this.size});
        }
        catch (Exception e) {
            LOG.error("Fail to load segment file {}.", (Object)this.path, (Object)e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean mmapFile(boolean create) {
        if (this.buffer != null) {
            return true;
        }
        File file = new File(this.path);
        if (file.exists()) {
            this.size = (int)file.length();
        } else if (!create) {
            LOG.error("File {} is not exists.", (Object)this.path);
            return false;
        }
        try (FileChannel fc = this.openFileChannel(create);){
            this.buffer = fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
            this.buffer.limit(this.size);
            if (!this.loadHeader()) {
                LOG.error("Fail to load segment header from file {}.", (Object)this.path);
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Fail to mmap segment file {}.", (Object)this.path, (Object)e);
            return false;
        }
    }

    private FileChannel openFileChannel(boolean create) throws IOException {
        if (create) {
            return FileChannel.open(Paths.get(this.path, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        return FileChannel.open(Paths.get(this.path, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    boolean loadHeader() {
        int oldPos = this.buffer.position();
        try {
            BufferUtils.position(this.buffer, 0);
            boolean bl = this.header.decode(this.buffer.asReadOnlyBuffer());
            return bl;
        }
        finally {
            BufferUtils.position(this.buffer, oldPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveHeader(boolean sync) {
        int oldPos = this.buffer.position();
        try {
            BufferUtils.position(this.buffer, 0);
            ByteBuffer headerBuf = this.header.encode();
            assert (headerBuf.remaining() == 18);
            this.buffer.put(headerBuf);
            if (sync) {
                this.fsync(this.buffer);
            }
        }
        finally {
            BufferUtils.position(this.buffer, oldPos);
        }
    }

    private boolean recover(SegmentFileOptions opts) throws IOException {
        LOG.info("Start to recover segment file {} from position {}.", (Object)this.path, (Object)opts.pos);
        this.wrotePos = opts.pos;
        if (this.wrotePos < 18) {
            this.wrotePos = 18;
        }
        BufferUtils.position(this.buffer, this.wrotePos);
        long start = Utils.monotonicMs();
        while (this.wrotePos < this.size) {
            if (this.buffer.remaining() < RECORD_MAGIC_BYTES_SIZE) {
                LOG.error("Fail to recover segment file {}, missing magic bytes.", (Object)this.path);
                return false;
            }
            byte[] magicBytes = new byte[RECORD_MAGIC_BYTES_SIZE];
            this.buffer.get(magicBytes);
            if (!Arrays.equals(RECORD_MAGIC_BYTES, magicBytes)) {
                boolean truncateDirty = false;
                int i = 0;
                for (byte b : magicBytes) {
                    ++i;
                    if (b == 0) continue;
                    if (opts.isLastFile) {
                        LOG.error("Corrupted magic bytes in segment file {} at pos={}, will truncate it.", (Object)this.path, (Object)(this.wrotePos + i));
                        truncateDirty = true;
                        break;
                    }
                    LOG.error("Fail to recover segment file {}, invalid magic bytes: {} at pos={}.", new Object[]{this.path, BytesUtil.toHex(magicBytes), this.wrotePos});
                    return false;
                }
                if (truncateDirty) {
                    this.truncateFile(opts.sync);
                    break;
                }
                BufferUtils.position(this.buffer, this.buffer.position() - RECORD_MAGIC_BYTES_SIZE);
                break;
            }
            if (this.buffer.remaining() < 4) {
                if (opts.isLastFile) {
                    LOG.error("Corrupted data length in segment file {} at pos={}, will truncate it.", (Object)this.path, (Object)this.buffer.position());
                    this.truncateFile(opts.sync);
                    break;
                }
                LOG.error("Fail to recover segment file {}, invalid data length remaining: {}, expected {} at pos={}.", new Object[]{this.path, this.buffer.remaining(), 4, this.wrotePos});
                return false;
            }
            int dataLen = this.buffer.getInt();
            if (this.buffer.remaining() < dataLen) {
                if (opts.isLastFile) {
                    LOG.error("Corrupted data in segment file {} at pos={},  expectDataLength={}, but remaining is {}, will truncate it.", new Object[]{this.path, this.buffer.position(), dataLen, this.buffer.remaining()});
                    this.truncateFile(opts.sync);
                    break;
                }
                LOG.error("Fail to recover segment file {}, invalid data: expected {} bytes in buf but actual {} at pos={}.", new Object[]{this.path, dataLen, this.buffer.remaining(), this.wrotePos});
                return false;
            }
            this.buffer.position(this.buffer.position() + dataLen);
            this.wrotePos += RECORD_MAGIC_BYTES_SIZE + 4 + dataLen;
        }
        LOG.info("Recover segment file {} cost {} millis.", (Object)this.path, (Object)(Utils.monotonicMs() - start));
        return true;
    }

    private void truncateFile(boolean sync) throws IOException {
        this.clear(this.wrotePos, sync);
        this.buffer.position(this.wrotePos);
        LOG.warn("Truncated segment file {} from pos={}.", (Object)this.path, (Object)this.wrotePos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reachesFileEndBy(long waitToWroteBytes) {
        this.readLock.lock();
        try {
            boolean bl = (long)this.wrotePos + waitToWroteBytes > (long)this.size;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isFull() {
        return this.reachesFileEndBy(1L);
    }

    static int getWriteBytes(byte[] data) {
        return RECORD_MAGIC_BYTES_SIZE + 4 + data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(long logIndex, byte[] data, RocksDBLogStorage.WriteContext ctx) {
        int pos = -1;
        MappedByteBuffer buf = null;
        this.writeLock.lock();
        try {
            assert (this.wrotePos == this.buffer.position());
            buf = this.buffer;
            pos = this.wrotePos;
            this.wrotePos += RECORD_MAGIC_BYTES_SIZE + 4 + data.length;
            this.buffer.position(this.wrotePos);
            if (this.isBlank() || pos == 18) {
                this.header.firstLogIndex = logIndex;
                this.saveHeader(false);
            }
            this.lastLogIndex = logIndex;
            int n = pos;
            return n;
        }
        finally {
            this.writeLock.unlock();
            int wroteIndex = pos;
            MappedByteBuffer buffer = buf;
            this.writeExecutor.execute(() -> {
                try {
                    SegmentFile.put(buffer, wroteIndex, RECORD_MAGIC_BYTES);
                    SegmentFile.putInt(buffer, wroteIndex + RECORD_MAGIC_BYTES_SIZE, data.length);
                    SegmentFile.put(buffer, wroteIndex + RECORD_MAGIC_BYTES_SIZE + 4, data);
                }
                catch (Exception e) {
                    ctx.setError(e);
                }
                finally {
                    ctx.finishJob();
                }
            });
        }
    }

    private static void putInt(MappedByteBuffer buffer, int index, int n) {
        byte[] bs = new byte[4];
        Bits.putInt(bs, 0, n);
        for (int i = 0; i < bs.length; ++i) {
            buffer.put(index + i, bs[i]);
        }
    }

    private static void put(MappedByteBuffer buffer, int index, byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            buffer.put(index + i, data[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(long logIndex, int pos) throws IOException {
        assert (pos >= 18);
        this.swapInIfNeed();
        this.readLock.lock();
        try {
            if (logIndex < this.header.firstLogIndex || logIndex > this.lastLogIndex) {
                LOG.warn("Try to read data from segment file {} out of range, logIndex={}, readPos={}, firstLogIndex={}, lastLogIndex={}.", new Object[]{this.path, logIndex, pos, this.header.firstLogIndex, this.lastLogIndex});
                byte[] byArray = null;
                return byArray;
            }
            if (pos >= this.committedPos) {
                LOG.warn("Try to read data from segment file {} out of comitted position, logIndex={}, readPos={}, wrotePos={}, this.committedPos={}.", new Object[]{this.path, logIndex, pos, this.wrotePos, this.committedPos});
                byte[] byArray = null;
                return byArray;
            }
            ByteBuffer readBuffer = this.buffer.asReadOnlyBuffer();
            readBuffer.position(pos);
            if (readBuffer.remaining() < RECORD_MAGIC_BYTES_SIZE) {
                throw new IOException("Missing magic buffer.");
            }
            readBuffer.position(pos + RECORD_MAGIC_BYTES_SIZE);
            int dataLen = readBuffer.getInt();
            byte[] data = new byte[dataLen];
            readBuffer.get(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void swapInIfNeed() {
        if (this.swappedOut) {
            this.swapIn();
        }
    }

    public void sync(boolean sync) throws IOException {
        MappedByteBuffer buf = null;
        this.writeLock.lock();
        try {
            if (this.committedPos >= this.wrotePos) {
                return;
            }
            this.committedPos = this.wrotePos;
            buf = this.buffer;
            LOG.debug("Commit segment file {} at pos {}.", (Object)this.path, (Object)this.committedPos);
        }
        finally {
            this.writeLock.unlock();
        }
        if (sync) {
            this.fsync(buf);
        }
    }

    private void fsync(MappedByteBuffer buffer) {
        if (buffer != null) {
            long startMs = Utils.monotonicMs();
            buffer.force();
            long cost = Utils.monotonicMs() - startMs;
            if (cost >= 1000L) {
                LOG.warn("Call fsync on file {}  cost {} ms.", (Object)this.path, (Object)cost);
            }
        }
    }

    public void destroy() {
        this.writeLock.lock();
        try {
            this.shutdown();
            FileUtils.deleteQuietly((File)new File(this.path));
            LOG.info("Deleted segment file {}.", (Object)this.path);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.writeLock.lock();
        try {
            if (this.buffer == null) {
                return;
            }
            this.hintUnload();
            Utils.unmap(this.buffer);
            this.buffer = null;
            LOG.info("Unloaded segment file {}, current status: {}.", (Object)this.path, (Object)this.toString());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return "SegmentFile [firstLogIndex=" + this.header.firstLogIndex + ", lastLogIndex=" + this.lastLogIndex + ", size=" + this.size + ", path=" + this.path + ", wrotePos=" + this.wrotePos + ", committedPos=" + this.committedPos + "]";
    }

    static {
        try {
            Method method;
            Class<?> clazz = Class.forName("sun.nio.ch.DirectBuffer");
            if (clazz != null && (method = clazz.getMethod("address", new Class[0])) != null) {
                ADDRESS_METHOD = MethodHandles.lookup().unreflect(method);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class SegmentFileOptions {
        final boolean recover;
        final int pos;
        final boolean isLastFile;
        final boolean isNewFile;
        final boolean sync;

        private SegmentFileOptions(boolean recover, boolean isLastFile, boolean isNewFile, boolean sync, int pos) {
            this.isNewFile = isNewFile;
            this.isLastFile = isLastFile;
            this.recover = recover;
            this.sync = sync;
            this.pos = pos;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            boolean recover = false;
            int pos = 0;
            boolean isLastFile = false;
            boolean isNewFile = false;
            boolean sync = true;

            public Builder setRecover(boolean recover) {
                this.recover = recover;
                return this;
            }

            public Builder setPos(int pos) {
                this.pos = pos;
                return this;
            }

            public Builder setLastFile(boolean isLastFile) {
                this.isLastFile = isLastFile;
                return this;
            }

            public Builder setNewFile(boolean isNewFile) {
                this.isNewFile = isNewFile;
                return this;
            }

            public Builder setSync(boolean sync) {
                this.sync = sync;
                return this;
            }

            public SegmentFileOptions build() {
                return new SegmentFileOptions(this.recover, this.isLastFile, this.isNewFile, this.sync, this.pos);
            }
        }
    }

    public static class SegmentHeader {
        private static final long RESERVED_FLAG = 0L;
        volatile long firstLogIndex = -99L;
        long reserved;
        private static final byte MAGIC = 32;

        ByteBuffer encode() {
            ByteBuffer buffer = ByteBuffer.allocate(18);
            buffer.put((byte)32);
            buffer.put((byte)32);
            buffer.putLong(this.firstLogIndex);
            buffer.putLong(0L);
            BufferUtils.flip(buffer);
            return buffer;
        }

        boolean decode(ByteBuffer buffer) {
            if (buffer == null || buffer.remaining() < 18) {
                LOG.error("Fail to decode segment header, invalid buffer length: {}", (Object)(buffer == null ? 0 : buffer.remaining()));
                return false;
            }
            if (buffer.get() != 32) {
                LOG.error("Fail to decode segment header, invalid magic.");
                return false;
            }
            if (buffer.get() != 32) {
                LOG.error("Fail to decode segment header, invalid magic.");
                return false;
            }
            this.firstLogIndex = buffer.getLong();
            return true;
        }
    }
}

