/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.benchmark;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.example.benchmark.LRUMap;
import org.apache.rocketmq.example.benchmark.StatsBenchmarkTProducer;
import org.apache.rocketmq.example.benchmark.TxSendConfig;

class TransactionListenerImpl
implements TransactionListener {
    private StatsBenchmarkTProducer statBenchmark;
    private TxSendConfig sendConfig;
    private final LRUMap<Long, Integer> cache = new LRUMap(200000);

    public TransactionListenerImpl(StatsBenchmarkTProducer statsBenchmark, TxSendConfig sendConfig) {
        this.statBenchmark = statsBenchmark;
        this.sendConfig = sendConfig;
    }

    public LocalTransactionState executeLocalTransaction(Message msg, Object arg) {
        return this.parseFromMsg((Message)msg).sendResult;
    }

    private MsgMeta parseFromMsg(Message msg) {
        byte[] bs = msg.getBody();
        ByteBuffer buf = ByteBuffer.wrap(bs);
        MsgMeta msgMeta = new MsgMeta();
        msgMeta.batchId = buf.getLong();
        msgMeta.msgId = buf.getLong();
        msgMeta.sendResult = LocalTransactionState.values()[buf.get()];
        msgMeta.checkResult = new ArrayList<LocalTransactionState>();
        for (int i = 0; i < 20; ++i) {
            msgMeta.checkResult.add(LocalTransactionState.values()[buf.get()]);
        }
        return msgMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalTransactionState checkLocalTransaction(MessageExt msg) {
        boolean dup;
        MsgMeta msgMeta = this.parseFromMsg((Message)msg);
        if (msgMeta.batchId != this.sendConfig.batchId) {
            return LocalTransactionState.ROLLBACK_MESSAGE;
        }
        this.statBenchmark.getCheckCount().increment();
        int times = 0;
        try {
            String checkTimes = msg.getUserProperty("TRANSACTION_CHECK_TIMES");
            times = Integer.parseInt(checkTimes);
        }
        catch (Exception e) {
            return LocalTransactionState.ROLLBACK_MESSAGE;
        }
        times = times <= 0 ? 1 : times;
        LRUMap<Long, Integer> lRUMap = this.cache;
        synchronized (lRUMap) {
            Integer oldCheckLog = (Integer)this.cache.get(msgMeta.msgId);
            Integer newCheckLog = oldCheckLog == null ? Integer.valueOf(1 << times - 1) : Integer.valueOf(oldCheckLog | 1 << times - 1);
            dup = newCheckLog.equals(oldCheckLog);
        }
        if (dup) {
            this.statBenchmark.getDuplicatedCheckCount().increment();
        }
        if (msgMeta.sendResult != LocalTransactionState.UNKNOW) {
            System.out.printf("%s unexpected check: msgId=%s,txId=%s,checkTimes=%s,sendResult=%s\n", new SimpleDateFormat("HH:mm:ss,SSS").format(new Date()), msg.getMsgId(), msg.getTransactionId(), msg.getUserProperty("TRANSACTION_CHECK_TIMES"), msgMeta.sendResult.toString());
            this.statBenchmark.getUnexpectedCheckCount().increment();
            return msgMeta.sendResult;
        }
        for (int i = 0; i < times - 1; ++i) {
            LocalTransactionState s = msgMeta.checkResult.get(i);
            if (s == LocalTransactionState.UNKNOW) continue;
            System.out.printf("%s unexpected check: msgId=%s,txId=%s,checkTimes=%s,sendResult,lastCheckResult=%s\n", new SimpleDateFormat("HH:mm:ss,SSS").format(new Date()), msg.getMsgId(), msg.getTransactionId(), msg.getUserProperty("TRANSACTION_CHECK_TIMES"), s);
            this.statBenchmark.getUnexpectedCheckCount().increment();
            return s;
        }
        return msgMeta.checkResult.get(times - 1);
    }

    private class MsgMeta {
        long batchId;
        long msgId;
        LocalTransactionState sendResult;
        List<LocalTransactionState> checkResult;

        private MsgMeta() {
        }
    }
}

