/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authentication.enums.UserType;
import org.apache.rocketmq.auth.authentication.factory.AuthenticationFactory;
import org.apache.rocketmq.auth.authentication.manager.AuthenticationMetadataManager;
import org.apache.rocketmq.auth.authentication.model.Subject;
import org.apache.rocketmq.auth.authentication.model.User;
import org.apache.rocketmq.auth.authorization.enums.Decision;
import org.apache.rocketmq.auth.authorization.enums.PolicyType;
import org.apache.rocketmq.auth.authorization.factory.AuthorizationFactory;
import org.apache.rocketmq.auth.authorization.manager.AuthorizationMetadataManager;
import org.apache.rocketmq.auth.authorization.model.Acl;
import org.apache.rocketmq.auth.authorization.model.Policy;
import org.apache.rocketmq.auth.authorization.model.PolicyEntry;
import org.apache.rocketmq.auth.authorization.model.Resource;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.auth.migration.v1.AclConfig;
import org.apache.rocketmq.auth.migration.v1.PlainAccessConfig;
import org.apache.rocketmq.auth.migration.v1.PlainPermissionManager;
import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.common.resource.ResourcePattern;
import org.apache.rocketmq.common.resource.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthMigrator {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final AuthConfig authConfig;
    private final PlainPermissionManager plainPermissionManager;
    private final AuthenticationMetadataManager authenticationMetadataManager;
    private final AuthorizationMetadataManager authorizationMetadataManager;

    public AuthMigrator(AuthConfig authConfig) {
        this.authConfig = authConfig;
        this.plainPermissionManager = new PlainPermissionManager();
        this.authenticationMetadataManager = AuthenticationFactory.getMetadataManager(authConfig);
        this.authorizationMetadataManager = AuthorizationFactory.getMetadataManager(authConfig);
    }

    public void migrate() {
        if (!this.authConfig.isMigrateAuthFromV1Enabled()) {
            return;
        }
        AclConfig aclConfig = this.plainPermissionManager.getAllAclConfig();
        List<PlainAccessConfig> accessConfigs = aclConfig.getPlainAccessConfigs();
        if (CollectionUtils.isEmpty(accessConfigs)) {
            return;
        }
        for (PlainAccessConfig accessConfig : accessConfigs) {
            this.doMigrate(accessConfig);
        }
    }

    private void doMigrate(PlainAccessConfig accessConfig) {
        ((CompletableFuture)((CompletableFuture)this.isUserExisted(accessConfig.getAccessKey()).thenCompose(existed -> {
            if (existed.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.createUserAndAcl(accessConfig);
        })).exceptionally(ex -> {
            LOG.error("[ACL MIGRATE] An error occurred while migrating ACL configurations for AccessKey:{}.", (Object)accessConfig.getAccessKey(), ex);
            return null;
        })).join();
    }

    private CompletableFuture<Void> createUserAndAcl(PlainAccessConfig accessConfig) {
        return this.createUser(accessConfig).thenCompose(nil -> this.createAcl(accessConfig));
    }

    private CompletableFuture<Void> createUser(PlainAccessConfig accessConfig) {
        User user = new User();
        user.setUsername(accessConfig.getAccessKey());
        user.setPassword(accessConfig.getSecretKey());
        if (accessConfig.isAdmin()) {
            user.setUserType(UserType.SUPER);
        } else {
            user.setUserType(UserType.NORMAL);
        }
        return this.authenticationMetadataManager.createUser(user);
    }

    private CompletableFuture<Void> createAcl(PlainAccessConfig config) {
        PolicyEntry policyEntry;
        Decision decision;
        List<Action> actions;
        Resource resource;
        PolicyEntry policyEntry2;
        Decision decision2;
        List<Action> actions2;
        Resource resource2;
        String perm;
        String[] temp;
        User subject = User.of(config.getAccessKey());
        ArrayList<Policy> policies = new ArrayList<Policy>();
        Policy customPolicy = null;
        if (CollectionUtils.isNotEmpty(config.getTopicPerms())) {
            for (String topicPerm : config.getTopicPerms()) {
                temp = StringUtils.split((String)topicPerm, (String)"=");
                if (temp.length != 2) continue;
                String topicName = StringUtils.trim((String)temp[0]);
                perm = StringUtils.trim((String)temp[1]);
                resource2 = Resource.ofTopic(topicName);
                actions2 = this.parseActions(perm);
                decision2 = this.parseDecision(perm);
                policyEntry2 = PolicyEntry.of(resource2, actions2, null, decision2);
                if (customPolicy == null) {
                    customPolicy = Policy.of(PolicyType.CUSTOM, new ArrayList<PolicyEntry>());
                }
                customPolicy.getEntries().add(policyEntry2);
            }
        }
        if (CollectionUtils.isNotEmpty(config.getGroupPerms())) {
            for (String groupPerm : config.getGroupPerms()) {
                temp = StringUtils.split((String)groupPerm, (String)"=");
                if (temp.length != 2) continue;
                String groupName = StringUtils.trim((String)temp[0]);
                perm = StringUtils.trim((String)temp[1]);
                resource2 = Resource.ofGroup(groupName);
                actions2 = this.parseActions(perm);
                decision2 = this.parseDecision(perm);
                policyEntry2 = PolicyEntry.of(resource2, actions2, null, decision2);
                if (customPolicy == null) {
                    customPolicy = Policy.of(PolicyType.CUSTOM, new ArrayList<PolicyEntry>());
                }
                customPolicy.getEntries().add(policyEntry2);
            }
        }
        if (customPolicy != null) {
            policies.add(customPolicy);
        }
        Policy defaultPolicy = null;
        if (StringUtils.isNotBlank((CharSequence)config.getDefaultTopicPerm())) {
            String topicPerm;
            topicPerm = StringUtils.trim((String)config.getDefaultTopicPerm());
            resource = Resource.of(ResourceType.TOPIC, null, ResourcePattern.ANY);
            actions = this.parseActions(topicPerm);
            decision = this.parseDecision(topicPerm);
            policyEntry = PolicyEntry.of(resource, actions, null, decision);
            defaultPolicy = Policy.of(PolicyType.DEFAULT, new ArrayList<PolicyEntry>());
            defaultPolicy.getEntries().add(policyEntry);
        }
        if (StringUtils.isNotBlank((CharSequence)config.getDefaultGroupPerm())) {
            String groupPerm;
            groupPerm = StringUtils.trim((String)config.getDefaultGroupPerm());
            resource = Resource.of(ResourceType.GROUP, null, ResourcePattern.ANY);
            actions = this.parseActions(groupPerm);
            decision = this.parseDecision(groupPerm);
            policyEntry = PolicyEntry.of(resource, actions, null, decision);
            if (defaultPolicy == null) {
                defaultPolicy = Policy.of(PolicyType.DEFAULT, new ArrayList<PolicyEntry>());
            }
            defaultPolicy.getEntries().add(policyEntry);
        }
        if (defaultPolicy != null) {
            policies.add(defaultPolicy);
        }
        if (CollectionUtils.isEmpty(policies)) {
            return CompletableFuture.completedFuture(null);
        }
        Acl acl = Acl.of((Subject)subject, policies);
        return this.authorizationMetadataManager.createAcl(acl);
    }

    private Decision parseDecision(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return Decision.DENY;
        }
        return StringUtils.equals((CharSequence)str, (CharSequence)"DENY") ? Decision.DENY : Decision.ALLOW;
    }

    private List<Action> parseActions(String str) {
        ArrayList<Action> result = new ArrayList<Action>();
        if (StringUtils.isBlank((CharSequence)str)) {
            result.add(Action.ALL);
        }
        switch (StringUtils.trim((String)str)) {
            case "PUB": {
                result.add(Action.PUB);
                break;
            }
            case "SUB": {
                result.add(Action.SUB);
                break;
            }
            case "PUB|SUB": 
            case "SUB|PUB": {
                result.add(Action.PUB);
                result.add(Action.SUB);
                break;
            }
            case "DENY": {
                result.add(Action.ALL);
                break;
            }
            default: {
                result.add(Action.ALL);
            }
        }
        return result;
    }

    private CompletableFuture<Boolean> isUserExisted(String username) {
        return this.authenticationMetadataManager.getUser(username).thenApply(Objects::nonNull);
    }
}

