/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.srvutil;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.common.LifecycleAwareServiceThread;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class FileWatchService
extends LifecycleAwareServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private final Map<String, String> currentHash = new HashMap<String, String>();
    private final Listener listener;
    private static final int WATCH_INTERVAL = 500;
    private final MessageDigest md = MessageDigest.getInstance("MD5");

    public FileWatchService(String[] watchFiles, Listener listener) throws Exception {
        this.listener = listener;
        for (String file : watchFiles) {
            if (Strings.isNullOrEmpty((String)file) || !new File(file).exists()) continue;
            this.currentHash.put(file, this.md5Digest(file));
        }
    }

    public String getServiceName() {
        return "FileWatchService";
    }

    public void run0() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                this.waitForRunning(500L);
                for (Map.Entry<String, String> entry : this.currentHash.entrySet()) {
                    String newHash = this.md5Digest(entry.getKey());
                    if (newHash.equals(entry.getValue())) continue;
                    entry.setValue(newHash);
                    this.listener.onChanged(entry.getKey());
                }
            }
            catch (Exception e) {
                log.warn(this.getServiceName() + " service raised an unexpected exception.", (Throwable)e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }

    private String md5Digest(String filePath) {
        byte[] raw;
        Path path = Paths.get(filePath, new String[0]);
        if (!path.toFile().exists()) {
            return this.currentHash.getOrDefault(filePath, "");
        }
        try {
            raw = Files.readAllBytes(path);
        }
        catch (IOException e) {
            log.info("Failed to read content of {}", (Object)filePath);
            return this.currentHash.getOrDefault(filePath, "");
        }
        this.md.update(raw);
        byte[] hash = this.md.digest();
        return UtilAll.bytes2string((byte[])hash);
    }

    public static interface Listener {
        public void onChanged(String var1);
    }
}

