/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public final class Es6RewriteScriptsToModules
extends NodeTraversal.AbstractPreOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;

    public Es6RewriteScriptsToModules(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    void forceToEs6Module(Node root) {
        if (Es6RewriteModules.isEs6ModuleRoot(root)) {
            return;
        }
        Node moduleNode = new Node(Token.MODULE_BODY).srcref(root);
        moduleNode.addChildrenToBack(root.removeChildren());
        root.addChildToBack(moduleNode);
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node file = root.getFirstChild(); file != null; file = file.getNext()) {
            this.hotSwapScript(file, null);
        }
    }

    @Override
    public void hotSwapScript(Node scriptNode, Node originalRoot) {
        Preconditions.checkArgument(scriptNode.isScript());
        NodeTraversal.traverse(this.compiler, scriptNode, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        CompilerInput.ModuleType moduleType;
        if (n.isScript() && (moduleType = this.compiler.getInput(n.getInputId()).getJsModuleType()) == CompilerInput.ModuleType.IMPORTED_SCRIPT) {
            this.forceToEs6Module(n);
            this.compiler.reportChangeToChangeScope(n);
        }
        return false;
    }
}

