/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.plugin;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;

public class NamespacePluginChangedEvent
extends AdminDataModelChangedEvent {
    public NamespacePluginChangedEvent(NamespacePluginVO source, NamespacePluginVO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        NamespacePluginVO after = (NamespacePluginVO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the namespace [%s] plugin [%s] is %s", after.getNamespaceId(), after.getName(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the namespace [%s] plugin [%s] is %s : %s", after.getNamespaceId(), after.getName(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        NamespacePluginVO before = (NamespacePluginVO)this.getBefore();
        Objects.requireNonNull(before);
        NamespacePluginVO after = (NamespacePluginVO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getConfig(), after.getConfig())) {
            builder.append(String.format("config[%s => %s] ", before.getConfig(), after.getConfig()));
        }
        if (!Objects.equals(before.getEnabled(), after.getEnabled())) {
            builder.append(String.format("enable[%s => %s] ", before.getEnabled(), after.getEnabled()));
        }
        if (!Objects.equals(before.getSort(), after.getSort())) {
            builder.append(String.format("sort[%s => %s] ", before.getSort(), after.getSort()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "namespace-plugin";
    }
}

