/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.monitor.observer;

import java.util.Objects;
import org.apache.shenyu.admin.model.entity.ScaleRuleDO;
import org.apache.shenyu.admin.scale.collector.provider.MetricData;
import org.apache.shenyu.admin.scale.monitor.observer.Observer;
import org.apache.shenyu.admin.scale.scaler.KubernetesScaler;
import org.apache.shenyu.admin.scale.scaler.dynamic.ScaleAction;
import org.apache.shenyu.admin.scale.scaler.dynamic.ScaleRuleEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleObserver
implements Observer {
    private static final Logger LOG = LoggerFactory.getLogger(ScaleObserver.class);
    private final KubernetesScaler kubernetesScaler;
    private final ScaleRuleEvaluator ruleEvaluator;

    public ScaleObserver(KubernetesScaler kubernetesScaler, ScaleRuleEvaluator ruleEvaluator) {
        this.kubernetesScaler = kubernetesScaler;
        this.ruleEvaluator = ruleEvaluator;
    }

    @Override
    public void update(MetricData metricData, ScaleRuleDO rule) {
        try {
            ScaleAction action = this.ruleEvaluator.evaluate(metricData, rule);
            if (Objects.nonNull(action)) {
                this.kubernetesScaler.scaleByAction(action);
            }
        }
        catch (Exception e) {
            LOG.error("update observer error. cause: {} ", (Object)e.getMessage());
        }
    }
}

