/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.ldap.core.mapping.LdapMappingContext;
import org.springframework.data.ldap.repository.query.AnnotatedLdapRepositoryQuery;
import org.springframework.data.ldap.repository.query.LdapQueryMethod;
import org.springframework.data.ldap.repository.query.PartTreeLdapRepositoryQuery;
import org.springframework.data.ldap.repository.support.LdapEntityInformation;
import org.springframework.data.ldap.repository.support.QuerydslLdapPredicateExecutor;
import org.springframework.data.ldap.repository.support.SimpleLdapRepository;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.util.Assert;

public class LdapRepositoryFactory
extends RepositoryFactorySupport {
    private final LdapQueryLookupStrategy queryLookupStrategy;
    private final LdapOperations ldapOperations;
    private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext;
    private final EntityInstantiators instantiators = new EntityInstantiators();

    public LdapRepositoryFactory(LdapOperations ldapOperations) {
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null");
        this.ldapOperations = ldapOperations;
        this.mappingContext = new LdapMappingContext();
        this.queryLookupStrategy = new LdapQueryLookupStrategy(ldapOperations, this.instantiators, this.mappingContext);
    }

    LdapRepositoryFactory(LdapOperations ldapOperations, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null");
        Assert.notNull(mappingContext, (String)"LdapMappingContext must not be null");
        this.queryLookupStrategy = new LdapQueryLookupStrategy(ldapOperations, this.instantiators, mappingContext);
        this.ldapOperations = ldapOperations;
        this.mappingContext = mappingContext;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new LdapEntityInformation<T>(domainClass, this.ldapOperations.getObjectDirectoryMapper());
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleLdapRepository.class;
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return this.getRepositoryFragments(metadata, this.ldapOperations);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata, LdapOperations operations) {
        boolean isQueryDslRepository;
        boolean bl = isQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        if (isQueryDslRepository) {
            if (metadata.isReactiveRepository()) {
                throw new InvalidDataAccessApiUsageException("Cannot combine Querydsl and reactive repository support in a single interface");
            }
            return RepositoryComposition.RepositoryFragments.just((Object[])new Object[]{new QuerydslLdapPredicateExecutor(this.getEntityInformation(metadata.getDomainType()), this.getProjectionFactory(), operations, this.mappingContext)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        boolean acceptsMappingContext = LdapRepositoryFactory.acceptsMappingContext(information);
        if (acceptsMappingContext) {
            return this.getTargetRepositoryViaReflection(information, new Object[]{this.ldapOperations, this.mappingContext, this.ldapOperations.getObjectDirectoryMapper(), information.getDomainType()});
        }
        return this.getTargetRepositoryViaReflection(information, new Object[]{this.ldapOperations, this.ldapOperations.getObjectDirectoryMapper(), information.getDomainType()});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(this.queryLookupStrategy);
    }

    private static boolean acceptsMappingContext(RepositoryInformation information) {
        Class repositoryBaseClass = information.getRepositoryBaseClass();
        Constructor<?>[] declaredConstructors = repositoryBaseClass.getDeclaredConstructors();
        boolean acceptsMappingContext = false;
        for (Constructor<?> declaredConstructor : declaredConstructors) {
            Class<?>[] parameterTypes = declaredConstructor.getParameterTypes();
            if (parameterTypes.length != 4 || !parameterTypes[1].isAssignableFrom(LdapMappingContext.class)) continue;
            acceptsMappingContext = true;
        }
        return acceptsMappingContext;
    }

    private static final class LdapQueryLookupStrategy
    implements QueryLookupStrategy {
        private final LdapOperations ldapOperations;
        private final EntityInstantiators instantiators;
        private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext;

        public LdapQueryLookupStrategy(LdapOperations ldapOperations, EntityInstantiators instantiators, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
            this.ldapOperations = ldapOperations;
            this.instantiators = instantiators;
            this.mappingContext = mappingContext;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            LdapQueryMethod queryMethod = new LdapQueryMethod(method, metadata, factory);
            Class domainType = metadata.getDomainType();
            if (queryMethod.hasQueryAnnotation()) {
                return new AnnotatedLdapRepositoryQuery(queryMethod, domainType, this.ldapOperations, this.mappingContext, this.instantiators);
            }
            return new PartTreeLdapRepositoryQuery(queryMethod, domainType, this.ldapOperations, this.mappingContext, this.instantiators);
        }
    }
}

