/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;

public class MemoryLimitCalculator {
    private static volatile long maxAvailable;
    private static final AtomicBoolean REFRESH_STARTED;

    private static void checkAndScheduleRefresh() {
        if (!REFRESH_STARTED.get()) {
            MemoryLimitCalculator.refresh();
            if (REFRESH_STARTED.compareAndSet(false, true)) {
                ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create("Shenyu-Memory-Calculator-", false));
                scheduledExecutorService.scheduleWithFixedDelay(MemoryLimitCalculator::refresh, 50L, 50L, TimeUnit.MILLISECONDS);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    REFRESH_STARTED.set(false);
                    scheduledExecutorService.shutdown();
                }));
            }
        }
    }

    private static void refresh() {
        maxAvailable = Runtime.getRuntime().freeMemory();
    }

    public static long maxAvailable() {
        MemoryLimitCalculator.checkAndScheduleRefresh();
        return maxAvailable;
    }

    public static long calculate(float percentage) {
        if (percentage <= 0.0f || percentage > 1.0f) {
            throw new IllegalArgumentException();
        }
        MemoryLimitCalculator.checkAndScheduleRefresh();
        return (long)((float)MemoryLimitCalculator.maxAvailable() * percentage);
    }

    public static long defaultLimit() {
        MemoryLimitCalculator.checkAndScheduleRefresh();
        return (long)((double)MemoryLimitCalculator.maxAvailable() * 0.8);
    }

    static {
        REFRESH_STARTED = new AtomicBoolean(false);
    }
}

