/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import jakarta.servlet.ServletContext;

public class ServletContextSupport {
    private ServletContext servletContext = null;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected String getContextInitParam(String paramName) {
        return this.getServletContext().getInitParameter(paramName);
    }

    private ServletContext getRequiredServletContext() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext == null) {
            String msg = "ServletContext property must be set via the setServletContext method.";
            throw new IllegalStateException(msg);
        }
        return servletContext;
    }

    protected void setContextAttribute(String key, Object value) {
        if (value == null) {
            this.removeContextAttribute(key);
        } else {
            this.getRequiredServletContext().setAttribute(key, value);
        }
    }

    protected Object getContextAttribute(String key) {
        return this.getRequiredServletContext().getAttribute(key);
    }

    protected void removeContextAttribute(String key) {
        this.getRequiredServletContext().removeAttribute(key);
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected StringBuilder toStringBuilder() {
        return new StringBuilder(super.toString());
    }
}

