/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.ResolvableType;
import org.springframework.integration.annotation.Filter;
import org.springframework.integration.config.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.FilterFactoryBean;
import org.springframework.integration.filter.MessageFilter;
import org.springframework.integration.filter.MethodInvokingSelector;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FilterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Filter> {
    public FilterAnnotationPostProcessor() {
        this.messageHandlerAttributes.addAll(Arrays.asList("discardChannel", "throwExceptionOnRejection", "adviceChain", "discardWithinAdvice"));
    }

    @Override
    protected BeanDefinition resolveHandlerBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition, ResolvableType handlerBeanType, List<Annotation> annotations) {
        BeanDefinition handlerBeanDefinition = super.resolveHandlerBeanDefinition(beanName, beanDefinition, handlerBeanType, annotations);
        if (handlerBeanDefinition != null) {
            return handlerBeanDefinition;
        }
        BeanDefinition targetObjectBeanDefinition = FilterAnnotationPostProcessor.buildLambdaMessageProcessor(handlerBeanType, beanDefinition);
        if (targetObjectBeanDefinition == null) {
            targetObjectBeanDefinition = new RuntimeBeanReference(beanName);
        }
        AbstractBeanDefinition filterBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(FilterFactoryBean.class).addPropertyValue("targetObject", (Object)targetObjectBeanDefinition).getBeanDefinition();
        new AbstractMethodAnnotationPostProcessor.BeanDefinitionPropertiesMapper((BeanDefinition)filterBeanDefinition, annotations).setPropertyValue("discardWithinAdvice").setPropertyValue("throwExceptionOnRejection").setPropertyReference("discardChannel");
        return filterBeanDefinition;
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        String discardChannelName;
        String throwExceptionOnRejection;
        Assert.isTrue((Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType()) ? 1 : 0) != 0, (String)"The Filter annotation may only be applied to methods with a boolean return type.");
        MethodInvokingSelector selector = new MethodInvokingSelector(bean, method);
        MessageFilter filter2 = new MessageFilter(selector);
        String discardWithinAdvice = MessagingAnnotationUtils.resolveAttribute(annotations, "discardWithinAdvice", String.class);
        if (StringUtils.hasText((String)discardWithinAdvice)) {
            filter2.setDiscardWithinAdvice(this.resolveAttributeToBoolean(discardWithinAdvice));
        }
        if (StringUtils.hasText((String)(throwExceptionOnRejection = MessagingAnnotationUtils.resolveAttribute(annotations, "throwExceptionOnRejection", String.class)))) {
            filter2.setThrowExceptionOnRejection(this.resolveAttributeToBoolean(throwExceptionOnRejection));
        }
        if (StringUtils.hasText((String)(discardChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, "discardChannel", String.class)))) {
            filter2.setDiscardChannelName(discardChannelName);
        }
        FilterAnnotationPostProcessor.setOutputChannelIfPresent(annotations, filter2);
        return filter2;
    }
}

