/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.dsl.IntegrationDsl;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@IntegrationDsl
public abstract class IntegrationComponentSpec<S extends IntegrationComponentSpec<S, T>, T>
implements FactoryBean<T>,
InitializingBean,
DisposableBean,
SmartLifecycle {
    protected static final SpelExpressionParser PARSER = new SpelExpressionParser();
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected volatile T target;
    private String id;

    protected S id(@Nullable String idToSet) {
        this.id = idToSet;
        return this._this();
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public Class<?> getObjectType() {
        return this.getObject().getClass();
    }

    @NonNull
    public T getObject() {
        if (this.target == null) {
            this.target = this.doGet();
        }
        return this.target;
    }

    public void afterPropertiesSet() {
        try {
            T t = this.target;
            if (t instanceof InitializingBean) {
                InitializingBean initializingBean = (InitializingBean)t;
                initializingBean.afterPropertiesSet();
            }
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Cannot initialize bean: " + this.target, (Throwable)ex);
        }
    }

    public void destroy() {
        T t = this.target;
        if (t instanceof DisposableBean) {
            DisposableBean disposableBean = (DisposableBean)t;
            try {
                disposableBean.destroy();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot destroy bean: " + this.target, e);
            }
        }
    }

    public void start() {
        T t = this.target;
        if (t instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)t;
            lifecycle.start();
        }
    }

    public void stop() {
        T t = this.target;
        if (t instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)t;
            lifecycle.stop();
        }
    }

    public boolean isRunning() {
        Lifecycle lifecycle;
        T t = this.target;
        return !(t instanceof Lifecycle) || (lifecycle = (Lifecycle)t).isRunning();
    }

    public boolean isAutoStartup() {
        SmartLifecycle lifecycle;
        T t = this.target;
        return t instanceof SmartLifecycle && (lifecycle = (SmartLifecycle)t).isAutoStartup();
    }

    public void stop(Runnable callback) {
        T t = this.target;
        if (t instanceof SmartLifecycle) {
            SmartLifecycle lifecycle = (SmartLifecycle)t;
            lifecycle.stop(callback);
        } else {
            callback.run();
        }
    }

    public int getPhase() {
        T t = this.target;
        if (t instanceof SmartLifecycle) {
            SmartLifecycle lifecycle = (SmartLifecycle)t;
            return lifecycle.getPhase();
        }
        return 0;
    }

    protected final S _this() {
        return (S)this;
    }

    protected T doGet() {
        throw new UnsupportedOperationException();
    }
}

