/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.util.HashMap;
import java.util.Objects;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.opengis.util.GenericName;

final class OperationWrapper
extends PropertyTypeBuilder {
    private final AbstractIdentifiedType operation;

    OperationWrapper(FeatureTypeBuilder owner, AbstractIdentifiedType operation) {
        super(owner);
        this.operation = operation;
        this.minimumOccurs = 1;
        this.maximumOccurs = 1;
        this.initialize(operation);
    }

    @Override
    public AbstractIdentifiedType build() {
        return this.operation;
    }

    @Override
    final AbstractIdentifiedType buildForFeature() {
        FeatureTypeBuilder owner = this.owner();
        if (this.operation instanceof AbstractOperation) {
            AbstractOperation op = (AbstractOperation)this.operation;
            HashMap<String, AbstractIdentifiedType> dependencies = new HashMap<String, AbstractIdentifiedType>();
            for (String name : op.getDependencies()) {
                PropertyTypeBuilder target;
                try {
                    target = owner.getProperty(name);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
                if (target == null) continue;
                dependencies.put(name, target.build());
            }
            return op.updateDependencies(dependencies);
        }
        return this.operation;
    }

    @Override
    public PropertyTypeBuilder setMinimumOccurs(int occurs) {
        return this.readOnly(1, occurs);
    }

    @Override
    public PropertyTypeBuilder setMaximumOccurs(int occurs) {
        return this.readOnly(1, occurs);
    }

    @Override
    public PropertyTypeBuilder setName(GenericName name) {
        return this.readOnly(OperationWrapper.str(this.getName()), OperationWrapper.str(name));
    }

    @Override
    public PropertyTypeBuilder setDefinition(CharSequence definition) {
        return this.readOnly(this.getDefinition(), definition);
    }

    @Override
    public PropertyTypeBuilder setDesignation(CharSequence designation) {
        return this.readOnly(this.getDesignation(), designation);
    }

    @Override
    public PropertyTypeBuilder setDescription(CharSequence description) {
        return this.readOnly(this.getDescription(), description);
    }

    @Override
    public PropertyTypeBuilder setDeprecated(boolean deprecated) {
        return this.readOnly(this.isDeprecated(), deprecated);
    }

    private static String str(GenericName name) {
        return name != null ? name.toString() : null;
    }

    private OperationWrapper readOnly(Object expected, Object actual) {
        if (Objects.equals(expected, actual)) {
            return this;
        }
        throw new UnsupportedOperationException(this.errors().getString((short)185, PropertyTypeBuilder.class));
    }
}

