/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.internal.shared.MetadataServices;
import org.apache.sis.util.resources.Errors;

public final class CheckedArrayList<E>
extends ArrayList<E>
implements CheckedContainer<E> {
    private static final long serialVersionUID = -8265578982723471814L;
    private final Class<E> type;

    public CheckedArrayList(Class<E> type) {
        this.type = Objects.requireNonNull(type);
    }

    public CheckedArrayList(Class<E> type, int capacity) {
        super(capacity);
        this.type = Objects.requireNonNull(type);
    }

    public static <E> CheckedArrayList<E> castOrCopy(Collection<?> collection, Class<E> type) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof CheckedArrayList && ((CheckedArrayList)collection).type == type) {
            return (CheckedArrayList)collection;
        }
        CheckedArrayList list = new CheckedArrayList(type, collection.size());
        list.addAll(collection);
        return list;
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    public static String illegalElement(Collection<?> collection, Object element, Class<?> expectedType) {
        Object[] arguments;
        short key;
        if (MetadataServices.getInstance().isUnmarshalling()) {
            return null;
        }
        if (element == null) {
            key = 142;
            arguments = new Object[]{Classes.getShortClassName(collection) + "<" + Classes.getShortName(expectedType) + ">"};
        } else {
            key = 58;
            arguments = new Object[]{"element", expectedType, element.getClass()};
        }
        return Errors.format(key, arguments);
    }

    private boolean ensureValid(E element) {
        if (this.type.isInstance(element)) {
            return true;
        }
        String message = CheckedArrayList.illegalElement(this, element, this.type);
        if (message == null) {
            return false;
        }
        if (element == null) {
            throw new NullPointerException(message);
        }
        throw new ClassCastException(message);
    }

    private List<E> ensureValidCollection(Collection<? extends E> collection) {
        Object[] array;
        int count = 0;
        for (Object element : array = collection.toArray()) {
            if (!this.ensureValid(element)) continue;
            array[count++] = element;
        }
        return new Mediator<Object>(ArraysExt.resize(array, count));
    }

    @Override
    public E set(int index, E element) {
        if (this.ensureValid(element)) {
            return super.set(index, element);
        }
        return this.get(index);
    }

    @Override
    public boolean add(E element) {
        if (this.ensureValid(element)) {
            return super.add(element);
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        if (this.ensureValid(element)) {
            super.add(index, element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return super.addAll(this.ensureValidCollection(collection));
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        return super.addAll(index, this.ensureValidCollection(collection));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return Collections.checkedList(super.subList(fromIndex, toIndex), this.type);
    }

    private static final class Mediator<E>
    extends AbstractList<E> {
        private final E[] array;

        Mediator(E[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public E get(int index) {
            return this.array[index];
        }

        @Override
        public E[] toArray() {
            return this.array;
        }
    }
}

