/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.ClobImpl;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class ClobRDBMSMapping
extends LongVarcharRDBMSMapping {
    public ClobRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(2005, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(2005);
    }

    @Override
    public void setString(PreparedStatement ps, int param, String value) {
        if (this.getDatastoreAdapter().supportsOption("ClobSetUsingSetString")) {
            super.setString(ps, param, value);
        } else {
            this.setObject(ps, param, value);
        }
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        if (this.getDatastoreAdapter().supportsOption("ClobSetUsingSetString")) {
            super.setObject(ps, param, value);
        } else {
            try {
                if (value == null) {
                    ps.setNull(param, this.getTypeInfo().getDataType());
                } else {
                    ps.setClob(param, new ClobImpl((String)value));
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public String getString(ResultSet rs, int param) {
        if (this.getDatastoreAdapter().supportsOption("ClobSetUsingSetString")) {
            return super.getString(rs, param);
        }
        return (String)this.getObject(rs, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(ResultSet rs, int param) {
        String value;
        block9: {
            if (this.getDatastoreAdapter().supportsOption("ClobSetUsingSetString")) {
                return super.getObject(rs, param);
            }
            try {
                Clob clob = rs.getClob(param);
                if (!rs.wasNull()) {
                    BufferedReader br = new BufferedReader(clob.getCharacterStream());
                    try {
                        int c;
                        StringBuffer sb = new StringBuffer();
                        while ((c = br.read()) != -1) {
                            sb.append((char)c);
                        }
                        value = sb.toString();
                        break block9;
                    }
                    finally {
                        br.close();
                    }
                }
                value = null;
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }
}

