/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextPool;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.ApiAdapterFactory;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.cache.NullLevel2Cache;
import org.datanucleus.enhancer.jdo.JDOImplementationCreator;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionIsolationNotSupportedException;
import org.datanucleus.identity.IdentityKeyTranslator;
import org.datanucleus.identity.IdentityStringTranslator;
import org.datanucleus.identity.OID;
import org.datanucleus.management.FactoryStatistics;
import org.datanucleus.management.jmx.ManagementManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.state.ObjectProviderFactoryImpl;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.autostart.AutoStartMechanism;
import org.datanucleus.store.exceptions.DatastoreInitialisationException;
import org.datanucleus.store.federation.FederatedStoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.schema.SchemaScriptAwareStoreManager;
import org.datanucleus.store.schema.SchemaTool;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.transaction.jta.JTASyncRegistry;
import org.datanucleus.transaction.jta.JTASyncRegistryUnavailableException;
import org.datanucleus.transaction.jta.TransactionManagerFinder;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.validation.BeanValidatorHandler;

public class NucleusContext
implements Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private final ContextType type;
    private final PersistenceConfiguration config;
    private final PluginManager pluginManager;
    private MetaDataManager metaDataManager = null;
    private final String classLoaderResolverClassName;
    private final ApiAdapter apiAdapter;
    private TypeManager typeManager;
    private transient StoreManager storeMgr = null;
    private transient AutoStartMechanism starter = null;
    private boolean jca = false;
    private Level2Cache cache;
    private transient TransactionManager txManager = null;
    private transient javax.transaction.TransactionManager jtaTxManager = null;
    private transient JTASyncRegistry jtaSyncRegistry = null;
    private transient Map<String, ClassLoaderResolver> classLoaderResolverMap = new HashMap<String, ClassLoaderResolver>();
    private transient ManagementManager jmxManager = null;
    private transient FactoryStatistics statistics = null;
    public static final Random random = new Random();
    private Class datastoreIdentityClass = null;
    private IdentityStringTranslator idStringTranslator = null;
    private boolean idStringTranslatorInit = false;
    private IdentityKeyTranslator idKeyTranslator = null;
    private boolean idKeyTranslatorInit = false;
    private ImplementationCreator implCreator;
    private List<ExecutionContext.LifecycleListener> executionContextListeners = new ArrayList<ExecutionContext.LifecycleListener>();
    private transient FetchGroupManager fetchGrpMgr;
    private transient Object validatorFactory = null;
    private transient boolean validatorFactoryInit = false;
    private ExecutionContextPool ecPool = null;
    private ObjectProviderFactory opFactory = null;
    public static final Set<String> STARTUP_PROPERTIES = new HashSet<String>();

    public NucleusContext(String apiName, Map startupProps) {
        this(apiName, ContextType.PERSISTENCE, startupProps);
    }

    public NucleusContext(String apiName, Map startupProps, PluginManager pluginMgr) {
        this(apiName, ContextType.PERSISTENCE, startupProps, pluginMgr);
    }

    public NucleusContext(String apiName, ContextType type, Map startupProps) {
        this(apiName, type, startupProps, null);
    }

    public NucleusContext(String apiName, ContextType type, Map startupProps, PluginManager pluginMgr) {
        this.type = type;
        this.pluginManager = pluginMgr != null ? pluginMgr : PluginManager.createPluginManager(startupProps, this.getClass().getClassLoader());
        this.config = new PersistenceConfiguration(this);
        if (startupProps != null && !startupProps.isEmpty()) {
            this.config.setPersistenceProperties(startupProps);
        }
        String clrName = this.config.getStringProperty("datanucleus.classLoaderResolverName");
        this.classLoaderResolverClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.classloader_resolver", "name", clrName, "class-name");
        if (this.classLoaderResolverClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("001001", (Object)clrName)).setFatal();
        }
        if (apiName != null) {
            this.apiAdapter = ApiAdapterFactory.getInstance().getApiAdapter(apiName, this.pluginManager);
            this.config.setDefaultProperties(this.apiAdapter.getDefaultFactoryProperties());
        } else {
            this.apiAdapter = null;
        }
    }

    public synchronized void initialise() {
        if (this.type == ContextType.PERSISTENCE) {
            Set<String> propNamesWithDatastore;
            ClassLoaderResolver clr = this.getClassLoaderResolver(null);
            clr.registerUserClassLoader((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader"));
            boolean generateSchema = false;
            boolean generateScripts = false;
            String generateModeStr = this.config.getStringProperty("datanucleus.generateSchema.database.mode");
            if (generateModeStr == null || generateModeStr.equalsIgnoreCase("none")) {
                generateModeStr = this.config.getStringProperty("datanucleus.generateSchema.scripts.mode");
                generateScripts = true;
            }
            if (generateModeStr != null && !generateModeStr.equalsIgnoreCase("none")) {
                generateSchema = true;
                if (!this.config.getBooleanProperty("datanucleus.autoCreateSchema")) {
                    this.config.setProperty("datanucleus.autoCreateSchema", "true");
                }
                if (!this.config.getBooleanProperty("datanucleus.autoCreateTables")) {
                    this.config.setProperty("datanucleus.autoCreateTables", "true");
                }
                if (!this.config.getBooleanProperty("datanucleus.autoCreateColumns")) {
                    this.config.setProperty("datanucleus.autoCreateColumns", "true");
                }
                if (!this.config.getBooleanProperty("datanucleus.autoCreateConstraints")) {
                    this.config.setProperty("datanucleus.autoCreateConstraints", "true");
                }
                if (!this.config.getBooleanProperty("datanucleus.fixedDatastore")) {
                    this.config.setProperty("datanucleus.fixedDatastore", "false");
                }
                if (!this.config.getBooleanProperty("datanucleus.readOnlyDatastore")) {
                    this.config.setProperty("datanucleus.readOnlyDatastore", "false");
                }
            }
            if ((propNamesWithDatastore = this.config.getPropertyNamesWithPrefix("datanucleus.datastore.")) == null) {
                String reqdIsolation;
                NucleusLogger.DATASTORE.debug("Creating StoreManager for datastore");
                Map<String, Object> datastoreProps = this.config.getDatastoreProperties();
                this.storeMgr = NucleusContext.createStoreManagerForProperties(this.config.getPersistenceProperties(), datastoreProps, clr, this);
                String transactionIsolation = this.config.getStringProperty("datanucleus.transactionIsolation");
                if (transactionIsolation != null && !transactionIsolation.equalsIgnoreCase(reqdIsolation = NucleusContext.getTransactionIsolationForStoreManager(this.storeMgr, transactionIsolation))) {
                    this.config.setProperty("datanucleus.transactionIsolation", reqdIsolation);
                }
            } else {
                NucleusLogger.DATASTORE.debug("Creating FederatedStoreManager to handle federation of primary StoreManager and " + propNamesWithDatastore.size() + " secondary datastores");
                this.storeMgr = new FederatedStoreManager(clr, this);
            }
            NucleusLogger.DATASTORE.debug("StoreManager now created");
            if (this.config.getStringProperty("datanucleus.autoStartMechanism") != null) {
                this.initialiseAutoStart(clr);
            }
            if (generateSchema) {
                this.initialiseSchema(generateModeStr, generateScripts);
            }
            if (this.config.getStringProperty("datanucleus.PersistenceUnitName") != null && this.config.getBooleanProperty("datanucleus.persistenceUnitLoadClasses")) {
                Collection<String> loadedClasses = this.getMetaDataManager().getClassesWithMetaData();
                this.storeMgr.addClasses(loadedClasses.toArray(new String[loadedClasses.size()]), clr);
            }
            if (this.config.getBooleanProperty("datanucleus.query.compileNamedQueriesAtStartup")) {
                this.initialiseNamedQueries(clr);
            }
            if (this.ecPool == null) {
                this.ecPool = new ExecutionContextPool(this);
            }
            if (this.opFactory == null) {
                this.opFactory = new ObjectProviderFactoryImpl(this);
            }
        }
        this.logConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseAutoStart(ClassLoaderResolver clr) throws DatastoreInitialisationException {
        block33: {
            String autoStartMechanism = this.config.getStringProperty("datanucleus.autoStartMechanism");
            String autoStarterClassName = this.getPluginManager().getAttributeValueForExtension("org.datanucleus.autostart", "name", autoStartMechanism, "class-name");
            if (autoStarterClassName != null) {
                String mode = this.config.getStringProperty("datanucleus.autoStartMechanismMode");
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.CLASS_LOADER_RESOLVER};
                Object[] args = new Object[]{this.storeMgr, clr};
                try {
                    this.starter = (AutoStartMechanism)this.getPluginManager().createExecutableExtension("org.datanucleus.autostart", "name", autoStartMechanism, "class-name", argsClass, args);
                    if (mode.equalsIgnoreCase("None")) {
                        this.starter.setMode(AutoStartMechanism.Mode.NONE);
                    } else if (mode.equalsIgnoreCase("Checked")) {
                        this.starter.setMode(AutoStartMechanism.Mode.CHECKED);
                    } else if (mode.equalsIgnoreCase("Quiet")) {
                        this.starter.setMode(AutoStartMechanism.Mode.QUIET);
                    } else if (mode.equalsIgnoreCase("Ignored")) {
                        this.starter.setMode(AutoStartMechanism.Mode.IGNORED);
                    }
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.error(StringUtils.getStringFromStackTrace(e));
                }
            }
            if (this.starter == null) {
                return;
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("034005", (Object)autoStartMechanism));
            }
            boolean illegalState = false;
            try {
                Collection existingData;
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                if ((existingData = this.starter.getAllClassData()) == null || existingData.size() <= 0) break block33;
                ArrayList<String> classesNeedingAdding = new ArrayList<String>();
                for (StoreData data : existingData) {
                    Class classFound;
                    block34: {
                        if (!data.isFCO()) continue;
                        classFound = null;
                        try {
                            classFound = clr.classForName(data.getName());
                        }
                        catch (ClassNotResolvedException cnre) {
                            if (data.getInterfaceName() == null) break block34;
                            try {
                                this.getImplementationCreator().newInstance(clr.classForName(data.getInterfaceName()), clr);
                                classFound = clr.classForName(data.getName());
                            }
                            catch (ClassNotResolvedException cnre2) {
                                // empty catch block
                            }
                        }
                    }
                    if (classFound != null) {
                        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("032003", (Object)data.getName()));
                        classesNeedingAdding.add(data.getName());
                        if (data.getMetaData() != null) continue;
                        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(classFound, clr);
                        if (acmd != null) {
                            data.setMetaData(acmd);
                            continue;
                        }
                        String msg = LOCALISER.msg("034004", (Object)data.getName());
                        if (this.starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                            NucleusLogger.PERSISTENCE.error(msg);
                            throw new DatastoreInitialisationException(msg);
                        }
                        if (this.starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                            NucleusLogger.PERSISTENCE.warn(msg);
                            continue;
                        }
                        if (this.starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                        NucleusLogger.PERSISTENCE.warn(msg);
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034001", (Object)data.getName()));
                        this.starter.deleteClass(data.getName());
                        continue;
                    }
                    String msg = LOCALISER.msg("034000", (Object)data.getName());
                    if (this.starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new DatastoreInitialisationException(msg);
                    }
                    if (this.starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                        NucleusLogger.PERSISTENCE.warn(msg);
                        continue;
                    }
                    if (this.starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                    NucleusLogger.PERSISTENCE.warn(msg);
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034001", (Object)data.getName()));
                    this.starter.deleteClass(data.getName());
                }
                String[] classesToLoad = new String[classesNeedingAdding.size()];
                Iterator classesNeedingAddingIter = classesNeedingAdding.iterator();
                int n = 0;
                while (classesNeedingAddingIter.hasNext()) {
                    classesToLoad[n++] = (String)classesNeedingAddingIter.next();
                }
                try {
                    this.storeMgr.addClasses(classesToLoad, clr);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034002", e));
                    illegalState = true;
                }
            }
            finally {
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
                if (illegalState) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034003"));
                    this.starter = null;
                }
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("034006", (Object)autoStartMechanism));
                }
            }
        }
    }

    public AutoStartMechanism getAutoStartMechanism() {
        return this.starter;
    }

    protected void initialiseNamedQueries(ClassLoaderResolver clr) {
        MetaDataManager mmgr = this.getMetaDataManager();
        Set<String> queryNames = mmgr.getNamedQueryNames();
        if (queryNames != null) {
            ExecutionContext ec = this.getExecutionContext(null, null);
            for (String queryName : queryNames) {
                QueryMetaData qmd = mmgr.getMetaDataForQuery(null, clr, queryName);
                if (!qmd.getLanguage().equals(QueryLanguage.JPQL.toString()) && !qmd.getLanguage().equals(QueryLanguage.JDOQL.toString())) continue;
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug(LOCALISER.msg("008017", (Object)queryName, (Object)qmd.getQuery()));
                }
                Query q = this.storeMgr.getQueryManager().newQuery(qmd.getLanguage().toString(), ec, qmd.getQuery());
                q.compile();
                q.closeAll();
            }
            ec.close();
        }
    }

    protected void initialiseSchema(String generateModeStr, boolean generateScripts) {
        SchemaTool.Mode mode = null;
        if (generateModeStr.equalsIgnoreCase("create")) {
            mode = SchemaTool.Mode.CREATE;
        } else if (generateModeStr.equalsIgnoreCase("drop")) {
            mode = SchemaTool.Mode.DELETE;
        } else if (generateModeStr.equalsIgnoreCase("drop-and-create")) {
            mode = SchemaTool.Mode.DELETE_CREATE;
        }
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            if (mode == SchemaTool.Mode.CREATE) {
                NucleusLogger.DATASTORE_SCHEMA.debug(LOCALISER.msg("014000"));
            } else if (mode == SchemaTool.Mode.DELETE) {
                NucleusLogger.DATASTORE_SCHEMA.debug(LOCALISER.msg("014001"));
            } else if (mode == SchemaTool.Mode.DELETE_CREATE) {
                NucleusLogger.DATASTORE_SCHEMA.debug(LOCALISER.msg("014045"));
            }
        }
        TreeSet<String> schemaClassNames = null;
        MetaDataManager metaDataMgr = this.getMetaDataManager();
        FileMetaData[] filemds = metaDataMgr.getFileMetaData();
        schemaClassNames = new TreeSet<String>();
        if (filemds == null) {
            throw new NucleusUserException("No classes to process in generateSchema");
        }
        for (int i = 0; i < filemds.length; ++i) {
            for (int j = 0; j < filemds[i].getNoOfPackages(); ++j) {
                for (int k = 0; k < filemds[i].getPackage(j).getNoOfClasses(); ++k) {
                    String className = filemds[i].getPackage(j).getClass(k).getFullClassName();
                    if (schemaClassNames.contains(className)) continue;
                    schemaClassNames.add(className);
                }
            }
        }
        StoreManager storeMgr = this.getStoreManager();
        if (storeMgr instanceof SchemaAwareStoreManager) {
            String dropScript;
            String scriptContent;
            SchemaAwareStoreManager schemaStoreMgr = (SchemaAwareStoreManager)((Object)storeMgr);
            SchemaTool schemaTool = new SchemaTool();
            if (mode == SchemaTool.Mode.CREATE) {
                String createScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.create.source");
                if (!StringUtils.isWhitespace(createScript)) {
                    scriptContent = this.getDatastoreScriptForResourceName(createScript);
                    NucleusLogger.DATASTORE_SCHEMA.debug(">> createScript=" + scriptContent);
                    if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent)) {
                        ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent);
                    }
                }
                if (generateScripts) {
                    schemaTool.setDdlFile(this.config.getStringProperty("datanucleus.generateSchema.scripts.create.target"));
                }
                schemaTool.createSchema(schemaStoreMgr, schemaClassNames);
            } else if (mode == SchemaTool.Mode.DELETE) {
                dropScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.drop.source");
                if (!StringUtils.isWhitespace(dropScript)) {
                    scriptContent = this.getDatastoreScriptForResourceName(dropScript);
                    NucleusLogger.DATASTORE_SCHEMA.debug(">> dropScript=" + scriptContent);
                    if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent)) {
                        ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent);
                    }
                }
                if (generateScripts) {
                    schemaTool.setDdlFile(this.config.getStringProperty("datanucleus.generateSchema.scripts.drop.target"));
                }
                schemaTool.deleteSchema(schemaStoreMgr, schemaClassNames);
            } else if (mode == SchemaTool.Mode.DELETE_CREATE) {
                dropScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.drop.source");
                if (!StringUtils.isWhitespace(dropScript)) {
                    scriptContent = this.getDatastoreScriptForResourceName(dropScript);
                    NucleusLogger.DATASTORE_SCHEMA.debug(">> dropScript=" + scriptContent);
                    if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent)) {
                        ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent);
                    }
                }
                if (generateScripts) {
                    schemaTool.setDdlFile(this.config.getStringProperty("datanucleus.generateSchema.scripts.drop.target"));
                }
                schemaTool.deleteSchema(schemaStoreMgr, schemaClassNames);
                String createScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.create.source");
                if (!StringUtils.isWhitespace(createScript)) {
                    String scriptContent2 = this.getDatastoreScriptForResourceName(createScript);
                    NucleusLogger.DATASTORE_SCHEMA.debug(">> dropScript=" + scriptContent2);
                    if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent2)) {
                        ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent2);
                    }
                }
                if (generateScripts) {
                    schemaTool.setDdlFile(this.config.getStringProperty("datanucleus.generateSchema.scripts.create.target"));
                }
                schemaTool.createSchema(schemaStoreMgr, schemaClassNames);
            }
            String loadScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.load");
            if (!StringUtils.isWhitespace(loadScript)) {
                scriptContent = this.getDatastoreScriptForResourceName(loadScript);
                NucleusLogger.DATASTORE_SCHEMA.debug(">> loadScript=" + scriptContent);
                if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent)) {
                    ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent);
                }
            }
        } else if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug(LOCALISER.msg("008016", (Object)StringUtils.toJVMIDString(storeMgr)));
        }
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug(LOCALISER.msg("014043"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatastoreScriptForResourceName(String scriptResourceName) {
        if (StringUtils.isWhitespace(scriptResourceName)) {
            return null;
        }
        File file = new File(scriptResourceName);
        if (!file.exists()) {
            try {
                URI uri = new URI(scriptResourceName);
                file = new File(uri);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (file != null && file.exists()) {
            FileInputStream fis = null;
            try {
                int content;
                StringBuffer str = new StringBuffer();
                fis = new FileInputStream(file);
                while ((content = fis.read()) != -1) {
                    str.append((char)content);
                }
                String string = str.toString();
                return string;
            }
            catch (Exception e) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        NucleusLogger.DATASTORE_SCHEMA.info("Datastore script " + scriptResourceName + " was not a valid script; has to be a filename, or a URL string");
        return null;
    }

    public synchronized void close() {
        if (this.opFactory != null) {
            this.opFactory.close();
            this.opFactory = null;
        }
        if (this.ecPool != null) {
            this.ecPool.cleanUp();
            this.ecPool = null;
        }
        if (this.fetchGrpMgr != null) {
            this.fetchGrpMgr.clearFetchGroups();
        }
        if (this.storeMgr != null) {
            this.storeMgr.close();
            this.storeMgr = null;
        }
        if (this.metaDataManager != null) {
            this.metaDataManager.close();
            this.metaDataManager = null;
        }
        if (this.statistics != null) {
            if (this.jmxManager != null) {
                this.jmxManager.deregisterMBean(this.statistics.getRegisteredName());
            }
            this.statistics = null;
        }
        if (this.jmxManager != null) {
            this.jmxManager.close();
            this.jmxManager = null;
        }
        if (this.cache != null) {
            this.cache.close();
            NucleusLogger.CACHE.debug(LOCALISER.msg("004009"));
        }
        this.classLoaderResolverMap.clear();
        this.classLoaderResolverMap = null;
        this.datastoreIdentityClass = null;
    }

    public ExecutionContextPool getExecutionContextPool() {
        if (this.ecPool == null) {
            this.initialise();
        }
        return this.ecPool;
    }

    public ContextType getType() {
        return this.type;
    }

    public ApiAdapter getApiAdapter() {
        return this.apiAdapter;
    }

    public String getApiName() {
        return this.apiAdapter != null ? this.apiAdapter.getName() : null;
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.config;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public synchronized MetaDataManager getMetaDataManager() {
        if (this.metaDataManager == null) {
            String apiName = this.getApiName();
            try {
                this.metaDataManager = (MetaDataManager)this.getPluginManager().createExecutableExtension("org.datanucleus.metadata_manager", new String[]{"name"}, new String[]{apiName}, "class", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this});
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER.msg("008010", (Object)apiName, (Object)e.getMessage()), e);
            }
            if (this.metaDataManager == null) {
                throw new NucleusException(LOCALISER.msg("008009", (Object)apiName));
            }
        }
        return this.metaDataManager;
    }

    public TypeManager getTypeManager() {
        if (this.typeManager == null) {
            this.typeManager = new TypeManager(this);
        }
        return this.typeManager;
    }

    public ObjectProviderFactory getObjectProviderFactory() {
        if (this.opFactory == null) {
            this.initialise();
        }
        return this.opFactory;
    }

    public ExecutionContext getExecutionContext(Object owner, Map<String, Object> options) {
        return this.ecPool.checkOut(owner, options);
    }

    public ClassLoaderResolver getClassLoaderResolver(ClassLoader primaryLoader) {
        ClassLoaderResolver clr;
        String resolverName;
        String key = resolverName = this.config.getStringProperty("datanucleus.classLoaderResolverName");
        if (primaryLoader != null) {
            key = key + ":[" + StringUtils.toJVMIDString(primaryLoader) + "]";
        }
        if (this.classLoaderResolverMap == null) {
            this.classLoaderResolverMap = new HashMap<String, ClassLoaderResolver>();
        }
        if ((clr = this.classLoaderResolverMap.get(key)) != null) {
            return clr;
        }
        try {
            clr = (ClassLoaderResolver)this.pluginManager.createExecutableExtension("org.datanucleus.classloader_resolver", "name", resolverName, "class-name", new Class[]{ClassLoader.class}, new Object[]{primaryLoader});
            clr.registerUserClassLoader((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader"));
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(LOCALISER.msg("001002", (Object)this.classLoaderResolverClassName), cnfe).setFatal();
        }
        catch (Exception e) {
            throw new NucleusUserException(LOCALISER.msg("001003", (Object)this.classLoaderResolverClassName), e).setFatal();
        }
        this.classLoaderResolverMap.put(key, clr);
        return clr;
    }

    public static String getTransactionIsolationForStoreManager(StoreManager storeMgr, String transactionIsolation) {
        Collection srmOptions;
        if (transactionIsolation != null && !(srmOptions = storeMgr.getSupportedOptions()).contains("TransactionIsolationLevel." + transactionIsolation)) {
            if (transactionIsolation.equals("read-uncommitted")) {
                if (srmOptions.contains("TransactionIsolationLevel.read-committed")) {
                    return "read-committed";
                }
                if (srmOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    return "repeatable-read";
                }
                if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else if (transactionIsolation.equals("read-committed")) {
                if (srmOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    return "repeatable-read";
                }
                if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else if (transactionIsolation.equals("repeatable-read")) {
                if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else {
                throw new TransactionIsolationNotSupportedException(transactionIsolation);
            }
        }
        return transactionIsolation;
    }

    public static StoreManager createStoreManagerForProperties(Map<String, Object> props, Map<String, Object> datastoreProps, ClassLoaderResolver clr, NucleusContext nucCtx) {
        Extension[] exts = nucCtx.getPluginManager().getExtensionPoint("org.datanucleus.store_manager").getExtensions();
        Class[] ctrArgTypes = new Class[]{ClassConstants.CLASS_LOADER_RESOLVER, ClassConstants.NUCLEUS_CONTEXT, Map.class};
        Object[] ctrArgs = new Object[]{clr, nucCtx, datastoreProps};
        StoreManager storeMgr = null;
        String storeManagerType = (String)props.get("datanucleus.storeManagerType".toLowerCase());
        if (storeManagerType != null) {
            for (int e = 0; storeMgr == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; storeMgr == null && c < confElm.length; ++c) {
                    String key = confElm[c].getAttribute("key");
                    if (!key.equalsIgnoreCase(storeManagerType)) continue;
                    try {
                        storeMgr = (StoreManager)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "key", storeManagerType, "class-name", ctrArgTypes, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
            if (storeMgr == null) {
                throw new NucleusUserException(LOCALISER.msg("008004", (Object)storeManagerType)).setFatal();
            }
        }
        if (storeMgr == null) {
            int idx;
            String url = (String)props.get("datanucleus.connectionurl");
            if (url != null && (idx = url.indexOf(58)) > -1) {
                url = url.substring(0, idx);
            }
            for (int e = 0; storeMgr == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; storeMgr == null && c < confElm.length; ++c) {
                    String urlKey = confElm[c].getAttribute("url-key");
                    if (url != null && !urlKey.equalsIgnoreCase(url)) continue;
                    try {
                        storeMgr = (StoreManager)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "url-key", url == null ? urlKey : url, "class-name", ctrArgTypes, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
            if (storeMgr == null) {
                throw new NucleusUserException(LOCALISER.msg("008004", (Object)url)).setFatal();
            }
        }
        return storeMgr;
    }

    protected void logConfiguration() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("================= NucleusContext ===============");
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("008000", (Object)this.pluginManager.getVersionForBundle("org.datanucleus"), (Object)System.getProperty("java.version"), (Object)System.getProperty("os.name")));
            NucleusLogger.PERSISTENCE.debug("Persistence API : " + this.getApiName());
            if (this.config.hasPropertyNotNull("datanucleus.PersistenceUnitName")) {
                NucleusLogger.PERSISTENCE.debug("Persistence-Unit : " + this.config.getStringProperty("datanucleus.PersistenceUnitName"));
            }
            NucleusLogger.PERSISTENCE.debug("Plugin Registry : " + this.pluginManager.getRegistryClassName());
            Object primCL = this.config.getProperty("datanucleus.primaryClassLoader");
            NucleusLogger.PERSISTENCE.debug("ClassLoading : " + this.config.getStringProperty("datanucleus.classLoaderResolverName") + (primCL != null ? "primary=" + primCL : ""));
            if (this.type == ContextType.PERSISTENCE) {
                String autoStartMechanism;
                String timeZoneID = this.config.getStringProperty("datanucleus.ServerTimeZoneID");
                if (timeZoneID == null) {
                    timeZoneID = TimeZone.getDefault().getID();
                }
                NucleusLogger.PERSISTENCE.debug("Persistence : " + (this.config.getBooleanProperty("datanucleus.Multithreaded") ? "pm-multithreaded" : "pm-singlethreaded") + (this.config.getBooleanProperty("datanucleus.RetainValues") ? ", retain-values" : "") + (this.config.getBooleanProperty("datanucleus.RestoreValues") ? ", restore-values" : "") + (this.config.getBooleanProperty("datanucleus.NontransactionalRead") ? ", nontransactional-read" : "") + (this.config.getBooleanProperty("datanucleus.NontransactionalWrite") ? ", nontransactional-write" : "") + (this.config.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit") ? ", reachability-at-commit" : "") + (this.config.getBooleanProperty("datanucleus.DetachAllOnCommit") ? ", detach-all-on-commit" : "") + (this.config.getBooleanProperty("datanucleus.DetachAllOnRollback") ? ", detach-all-on-rollback" : "") + (this.config.getBooleanProperty("datanucleus.DetachOnClose") ? ", detach-on-close" : "") + (this.config.getBooleanProperty("datanucleus.CopyOnAttach") ? ", copy-on-attach" : "") + (this.config.getBooleanProperty("datanucleus.manageRelationships") ? (this.config.getBooleanProperty("datanucleus.manageRelationshipsChecks") ? ", managed-relations(checked)" : ", managed-relations(unchecked)") : "") + ", deletion-policy=" + this.config.getStringProperty("datanucleus.deletionPolicy") + (this.config.getBooleanProperty("datanucleus.IgnoreCache") ? ", ignoreCache" : "") + ", serverTimeZone=" + timeZoneID);
                String txnType = "RESOURCE_LOCAL";
                if (TransactionType.JTA.toString().equalsIgnoreCase(this.config.getStringProperty("datanucleus.TransactionType"))) {
                    txnType = this.isJcaMode() ? "JTA (via JCA adapter)" : "JTA";
                }
                if ((autoStartMechanism = this.config.getStringProperty("datanucleus.autoStartMechanism")) != null) {
                    String autoStartClassNames = this.config.getStringProperty("datanucleus.autoStartClassNames");
                    NucleusLogger.PERSISTENCE.debug("AutoStart : mechanism=" + autoStartMechanism + ", mode=" + this.config.getStringProperty("datanucleus.autoStartMechanismMode") + (autoStartClassNames != null ? ", classes=" + autoStartClassNames : ""));
                }
                NucleusLogger.PERSISTENCE.debug("Transactions : type=" + txnType + ", mode=" + (this.config.getBooleanProperty("datanucleus.Optimistic") ? "optimistic" : "datastore") + ", isolation=" + this.config.getStringProperty("datanucleus.transactionIsolation"));
                NucleusLogger.PERSISTENCE.debug("ValueGeneration : txn-isolation=" + this.config.getStringProperty("datanucleus.valuegeneration.transactionIsolation") + " connection=" + (this.config.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("New") ? "New" : "Existing"));
                NucleusLogger.PERSISTENCE.debug("Cache : Level1 (" + this.config.getStringProperty("datanucleus.cache.level1.type") + ")" + ", Level2 (" + this.config.getStringProperty("datanucleus.cache.level2.type") + ", mode=" + this.config.getStringProperty("datanucleus.cache.level2.mode") + ")" + ", QueryResults (" + this.config.getStringProperty("datanucleus.cache.queryResults.type") + ")" + (this.config.getBooleanProperty("datanucleus.cache.collections") ? ", Collections/Maps " : ""));
            }
            NucleusLogger.PERSISTENCE.debug("================================================");
        }
    }

    public synchronized Class getDatastoreIdentityClass() {
        if (this.datastoreIdentityClass == null) {
            String dsidName = this.config.getStringProperty("datanucleus.datastoreIdentityType");
            String datastoreIdentityClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.store_datastoreidentity", "name", dsidName, "class-name");
            if (datastoreIdentityClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)dsidName)).setFatal();
            }
            ClassLoaderResolver clr = this.getClassLoaderResolver(null);
            try {
                this.datastoreIdentityClass = clr.classForName(datastoreIdentityClassName, ClassConstants.NUCLEUS_CONTEXT_LOADER);
            }
            catch (ClassNotResolvedException cnre) {
                throw new NucleusUserException(LOCALISER.msg("002002", (Object)dsidName, (Object)datastoreIdentityClassName)).setFatal();
            }
        }
        return this.datastoreIdentityClass;
    }

    public synchronized IdentityStringTranslator getIdentityStringTranslator() {
        if (this.idStringTranslatorInit) {
            return this.idStringTranslator;
        }
        this.idStringTranslatorInit = true;
        String translatorType = this.config.getStringProperty("datanucleus.identityStringTranslatorType");
        if (translatorType != null) {
            try {
                this.idStringTranslator = (IdentityStringTranslator)this.pluginManager.createExecutableExtension("org.datanucleus.identity_string_translator", "name", translatorType, "class-name", null, null);
                return this.idStringTranslator;
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)translatorType)).setFatal();
            }
        }
        return null;
    }

    public synchronized IdentityKeyTranslator getIdentityKeyTranslator() {
        if (this.idKeyTranslatorInit) {
            return this.idKeyTranslator;
        }
        this.idKeyTranslatorInit = true;
        String translatorType = this.config.getStringProperty("datanucleus.identityKeyTranslatorType");
        if (translatorType != null) {
            try {
                this.idKeyTranslator = (IdentityKeyTranslator)this.pluginManager.createExecutableExtension("org.datanucleus.identity_key_translator", "name", translatorType, "class-name", null, null);
                return this.idKeyTranslator;
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)translatorType)).setFatal();
            }
        }
        return null;
    }

    public boolean statisticsEnabled() {
        return this.config.getBooleanProperty("datanucleus.enableStatistics") || this.getJMXManager() != null;
    }

    public synchronized ManagementManager getJMXManager() {
        if (this.jmxManager == null && this.config.getStringProperty("datanucleus.jmxType") != null) {
            this.jmxManager = new ManagementManager(this);
        }
        return this.jmxManager;
    }

    public synchronized FactoryStatistics getStatistics() {
        if (this.statistics == null && this.statisticsEnabled()) {
            String name = null;
            if (this.getJMXManager() != null) {
                name = this.jmxManager.getDomainName() + ":InstanceName=" + this.jmxManager.getInstanceName() + ",Type=" + FactoryStatistics.class.getName() + ",Name=Factory" + random.nextInt();
            }
            this.statistics = new FactoryStatistics(name);
            if (this.jmxManager != null) {
                this.jmxManager.registerMBean(this.statistics, name);
            }
        }
        return this.statistics;
    }

    public synchronized ImplementationCreator getImplementationCreator() {
        boolean useImplCreator;
        if (this.implCreator == null && (useImplCreator = this.config.getBooleanProperty("datanucleus.useImplementationCreator"))) {
            this.implCreator = new JDOImplementationCreator(this.getMetaDataManager());
        }
        return this.implCreator;
    }

    public synchronized TransactionManager getTransactionManager() {
        if (this.txManager == null) {
            this.txManager = new TransactionManager();
        }
        return this.txManager;
    }

    public synchronized javax.transaction.TransactionManager getJtaTransactionManager() {
        if (this.jtaTxManager == null) {
            this.jtaTxManager = new TransactionManagerFinder(this).getTransactionManager(this.getClassLoaderResolver((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader")));
            if (this.jtaTxManager == null) {
                throw new NucleusTransactionException(LOCALISER.msg("015030"));
            }
        }
        return this.jtaTxManager;
    }

    public JTASyncRegistry getJtaSyncRegistry() {
        if (this.jtaSyncRegistry == null) {
            try {
                this.jtaSyncRegistry = new JTASyncRegistry();
            }
            catch (JTASyncRegistryUnavailableException jsrue) {
                NucleusLogger.TRANSACTION.debug("JTA TransactionSynchronizationRegistry not found at JNDI java:comp/TransactionSynchronizationRegistry so using Transaction to register synchronisation");
                this.jtaSyncRegistry = null;
            }
        }
        return this.jtaSyncRegistry;
    }

    public boolean isStoreManagerInitialised() {
        return this.storeMgr != null;
    }

    public StoreManager getStoreManager() {
        if (this.storeMgr == null) {
            this.initialise();
        }
        return this.storeMgr;
    }

    public CallbackHandler getValidationHandler(ExecutionContext ec) {
        if (this.validatorFactoryInit && this.validatorFactory == null) {
            return null;
        }
        if (this.config.hasPropertyNotNull("datanucleus.validation.mode") && this.config.getStringProperty("datanucleus.validation.mode").equalsIgnoreCase("none")) {
            this.validatorFactoryInit = true;
            return null;
        }
        try {
            ec.getClassLoaderResolver().classForName("javax.validation.Validation");
        }
        catch (ClassNotResolvedException cnre) {
            this.validatorFactoryInit = true;
            return null;
        }
        try {
            if (this.validatorFactory == null) {
                this.validatorFactoryInit = true;
                this.validatorFactory = this.config.hasPropertyNotNull("datanucleus.validation.factory") ? this.config.getProperty("datanucleus.validation.factory") : Validation.buildDefaultValidatorFactory();
            }
            return new BeanValidatorHandler(ec, (ValidatorFactory)this.validatorFactory);
        }
        catch (Throwable ex) {
            if (this.config.hasPropertyNotNull("datanucleus.validation.mode") && this.config.getStringProperty("datanucleus.validation.mode").equalsIgnoreCase("callback")) {
                throw ec.getApiAdapter().getUserExceptionForException(ex.getMessage(), (Exception)ex);
            }
            NucleusLogger.GENERAL.warn("Unable to create validator handler", ex);
            return null;
        }
    }

    public boolean hasLevel2Cache() {
        this.getLevel2Cache();
        return !(this.cache instanceof NullLevel2Cache);
    }

    public Level2Cache getLevel2Cache() {
        if (this.cache == null) {
            String level2Type = this.config.getStringProperty("datanucleus.cache.level2.type");
            String level2ClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.cache_level2", "name", level2Type, "class-name");
            if (level2ClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("004000", (Object)level2Type)).setFatal();
            }
            try {
                this.cache = (Level2Cache)this.pluginManager.createExecutableExtension("org.datanucleus.cache_level2", "name", level2Type, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004002", (Object)level2Type));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("004001", (Object)level2Type, (Object)level2ClassName), e).setFatal();
            }
        }
        return this.cache;
    }

    public ExecutionContext.LifecycleListener[] getExecutionContextListeners() {
        return this.executionContextListeners.toArray(new ExecutionContext.LifecycleListener[this.executionContextListeners.size()]);
    }

    public void addExecutionContextListener(ExecutionContext.LifecycleListener listener) {
        this.executionContextListeners.add(listener);
    }

    public void removeExecutionContextListener(ExecutionContext.LifecycleListener listener) {
        this.executionContextListeners.remove(listener);
    }

    public synchronized void setJcaMode(boolean jca) {
        this.jca = jca;
    }

    public boolean isJcaMode() {
        return this.jca;
    }

    public synchronized FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this);
        }
        return this.fetchGrpMgr;
    }

    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    public void removeInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    public FetchGroup createInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().createFetchGroup(cls, name);
    }

    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        this.getMetaDataManager().getMetaDataForClass(cls, this.getClassLoaderResolver(cls.getClassLoader()));
        if (cls.isInterface() && !this.getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name);
    }

    public Set<FetchGroup> getFetchGroupsWithName(String name) {
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    public boolean isClassWithIdentityCacheable(Object id) {
        if (id == null) {
            return false;
        }
        AbstractClassMetaData cmd = null;
        if (id instanceof OID) {
            cmd = this.getMetaDataManager().getMetaDataForClass(((OID)id).getPcClass(), this.getClassLoaderResolver(id.getClass().getClassLoader()));
        } else if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            cmd = this.getMetaDataManager().getMetaDataForClass(this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id), this.getClassLoaderResolver(id.getClass().getClassLoader()));
        } else {
            Collection<AbstractClassMetaData> cmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName());
            if (cmds != null && !cmds.isEmpty()) {
                cmd = cmds.iterator().next();
            }
        }
        return this.isClassCacheable(cmd);
    }

    public boolean isClassCacheable(AbstractClassMetaData cmd) {
        String cacheMode = this.config.getStringProperty("datanucleus.cache.level2.mode");
        if (cacheMode.equalsIgnoreCase("ALL")) {
            return true;
        }
        if (cacheMode.equalsIgnoreCase("NONE")) {
            return false;
        }
        if (cacheMode.equalsIgnoreCase("ENABLE_SELECTIVE")) {
            if (cmd == null) {
                return true;
            }
            return cmd.isCacheable() != null && cmd.isCacheable() != false;
        }
        if (cacheMode.equalsIgnoreCase("DISABLE_SELECTIVE")) {
            if (cmd == null) {
                return true;
            }
            return cmd.isCacheable() == null || cmd.isCacheable() != false;
        }
        if (cmd == null) {
            return true;
        }
        Boolean cacheableFlag = cmd.isCacheable();
        if (cacheableFlag == null) {
            return true;
        }
        return cacheableFlag;
    }

    static {
        STARTUP_PROPERTIES.add("datanucleus.plugin.pluginRegistryClassName");
        STARTUP_PROPERTIES.add("datanucleus.plugin.pluginRegistryBundleCheck");
        STARTUP_PROPERTIES.add("datanucleus.plugin.allowUserBundles");
        STARTUP_PROPERTIES.add("datanucleus.plugin.validatePlugins");
        STARTUP_PROPERTIES.add("datanucleus.classLoaderResolverName");
        STARTUP_PROPERTIES.add("datanucleus.persistenceXmlFilename");
        STARTUP_PROPERTIES.add("datanucleus.primaryClassLoader");
    }

    public static enum ContextType {
        PERSISTENCE,
        ENHANCEMENT;

    }
}

