/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.Preconditions;

final class CheckpointStartRequest
implements ChannelStateWriteRequest {
    private final ChannelStateWriter.ChannelStateWriteResult targetResult;
    private final CheckpointStorageLocationReference locationReference;
    private final long checkpointId;

    CheckpointStartRequest(long checkpointId, ChannelStateWriter.ChannelStateWriteResult targetResult, CheckpointStorageLocationReference locationReference) {
        this.checkpointId = checkpointId;
        this.targetResult = (ChannelStateWriter.ChannelStateWriteResult)Preconditions.checkNotNull((Object)targetResult);
        this.locationReference = (CheckpointStorageLocationReference)Preconditions.checkNotNull((Object)locationReference);
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    ChannelStateWriter.ChannelStateWriteResult getTargetResult() {
        return this.targetResult;
    }

    public CheckpointStorageLocationReference getLocationReference() {
        return this.locationReference;
    }

    @Override
    public void cancel(Throwable cause) {
        this.targetResult.fail(cause);
    }

    public String toString() {
        return "start " + this.checkpointId;
    }
}

