/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.annotation.AppUpdated;
import org.apache.streampark.console.core.annotation.PermissionScope;
import org.apache.streampark.console.core.entity.Project;
import org.apache.streampark.console.core.enums.GitAuthorizedError;
import org.apache.streampark.console.core.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/project"})
public class ProjectController {
    private static final Logger log = LoggerFactory.getLogger(ProjectController.class);
    @Autowired
    private ProjectService projectService;

    @PostMapping(value={"create"})
    @PermissionScope(team="#project.teamId")
    @RequiresPermissions(value={"project:create"})
    public RestResponse create(Project project) {
        ApiAlertException.throwIfNull(project.getTeamId(), "The teamId can't be null. Create team failed.");
        return this.projectService.create(project);
    }

    @AppUpdated
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"project:update"})
    @PermissionScope(team="#project.teamId")
    public RestResponse update(Project project) {
        boolean update = this.projectService.update(project);
        return RestResponse.success().data(update);
    }

    @PostMapping(value={"get"})
    @PermissionScope(team="#project.teamId")
    public RestResponse get(Project project) {
        return RestResponse.success().data(this.projectService.getById(project.getId()));
    }

    @PostMapping(value={"build"})
    @RequiresPermissions(value={"project:build"})
    @PermissionScope(team="#project.teamId")
    public RestResponse build(Project project) throws Exception {
        this.projectService.build(project.getId());
        return RestResponse.success();
    }

    @PostMapping(value={"buildlog"})
    @RequiresPermissions(value={"project:build"})
    @PermissionScope(team="#teamId")
    public RestResponse buildLog(Long id, @RequestParam(value="startOffset", required=false) Long startOffset, Long teamId) {
        return this.projectService.getBuildLog(id, startOffset);
    }

    @PostMapping(value={"list"})
    @RequiresPermissions(value={"project:view"})
    @PermissionScope(team="#project.teamId")
    public RestResponse list(Project project, RestRequest restRequest) {
        if (project.getTeamId() == null) {
            return RestResponse.success(Collections.emptyList());
        }
        IPage<Project> page = this.projectService.page(project, restRequest);
        return RestResponse.success().data(page);
    }

    @PostMapping(value={"branches"})
    @PermissionScope(team="#project.teamId")
    public RestResponse branches(Project project) {
        List<String> branches = this.projectService.getAllBranches(project);
        List<String> tags = this.projectService.getAllTags(project);
        HashMap<String, List<String>> refs = new HashMap<String, List<String>>();
        refs.put("tags", tags);
        refs.put("branches", branches);
        return RestResponse.success().data(refs);
    }

    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"project:delete"})
    @PermissionScope(team="#project.teamId")
    public RestResponse delete(Project project) {
        Boolean deleted = this.projectService.delete(project.getId());
        return RestResponse.success().data(deleted);
    }

    @PostMapping(value={"gitcheck"})
    @PermissionScope(team="#project.teamId")
    public RestResponse gitCheck(Project project) {
        GitAuthorizedError error = this.projectService.gitCheck(project);
        return RestResponse.success().data(error.getType());
    }

    @PostMapping(value={"exists"})
    @PermissionScope(team="#project.teamId")
    public RestResponse exists(Project project) {
        boolean exists = this.projectService.checkExists(project);
        return RestResponse.success().data(exists);
    }

    @PostMapping(value={"modules"})
    @PermissionScope(team="#project.teamId")
    public RestResponse modules(Project project) {
        List<String> result = this.projectService.modules(project.getId());
        return RestResponse.success().data(result);
    }

    @PostMapping(value={"jars"})
    @PermissionScope(team="#project.teamId")
    public RestResponse jars(Project project) {
        List<String> result = this.projectService.jars(project);
        return RestResponse.success().data(result);
    }

    @PostMapping(value={"listconf"})
    @PermissionScope(team="#project.teamId")
    public RestResponse listConf(Project project) {
        List<Map<String, Object>> list = this.projectService.listConf(project);
        return RestResponse.success().data(list);
    }

    @PostMapping(value={"select"})
    @PermissionScope(team="#teamId")
    public RestResponse select(@RequestParam Long teamId) {
        List<Project> list = this.projectService.findByTeamId(teamId);
        return RestResponse.success().data(list);
    }
}

