/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.watcher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.kubernetes.ChangeEventBus;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatchController;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.MetricWatcherConfig;
import org.apache.streampark.flink.kubernetes.event.FlinkJobCheckpointChangeEvent;
import org.apache.streampark.flink.kubernetes.model.CheckpointCV;
import org.apache.streampark.flink.kubernetes.model.ClusterKey$;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.kubernetes.watcher.Checkpoint;
import org.apache.streampark.flink.kubernetes.watcher.Checkpoint$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkCheckpointWatcher$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkWatcher;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u000b\u0017\u0001\rB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011)\u0019!C\u0002y!A\u0001\t\u0001B\u0001B\u0003%Q\b\u0003\u0005B\u0001\t\u0015\r\u0011b\u0001C\u0011!1\u0005A!A!\u0002\u0013\u0019\u0005\"B$\u0001\t\u0003A\u0005b\u0002(\u0001\u0005\u0004%Ya\u0014\u0005\u0007-\u0002\u0001\u000b\u0011\u0002)\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0013A\u0006\"\u00038\u0001\u0001\u0004\u0005\r\u0011\"\u0003p\u0011%1\u0007\u00011A\u0001B\u0003&\u0011\fC\u0003z\u0001\u0011\u0005#\u0010C\u0003|\u0001\u0011\u0005#\u0010C\u0003}\u0001\u0011\u0005#\u0010C\u0003~\u0001\u0011\u0005#\u0010C\u0003\u007f\u0001\u0011\u0005qpB\u0005\u00022Y\t\t\u0011#\u0001\u00024\u0019AQCFA\u0001\u0012\u0003\t)\u0004\u0003\u0004H%\u0011\u0005\u0011q\u0007\u0005\n\u0003s\u0011\u0012\u0013!C\u0001\u0003w\u0011aC\u00127j].\u001c\u0005.Z2la>Lg\u000e^,bi\u000eDWM\u001d\u0006\u0003/a\tqa^1uG\",'O\u0003\u0002\u001a5\u0005Q1.\u001e2fe:,G/Z:\u000b\u0005ma\u0012!\u00024mS:\\'BA\u000f\u001f\u0003)\u0019HO]3b[B\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!#F\r\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013\u0001B;uS2T!a\f\u000f\u0002\r\r|W.\\8o\u0013\t\tDF\u0001\u0004M_\u001e<WM\u001d\t\u0003gQj\u0011AF\u0005\u0003kY\u0011AB\u00127j].<\u0016\r^2iKJ\fAaY8oMB\u0011\u0001(O\u0007\u00021%\u0011!\b\u0007\u0002\u0014\u001b\u0016$(/[2XCR\u001c\u0007.\u001a:D_:4\u0017nZ\u0001\u0010o\u0006$8\r[\"p]R\u0014x\u000e\u001c7feV\tQ\b\u0005\u00029}%\u0011q\b\u0007\u0002\u0018\r2Lgn[&9g^\u000bGo\u00195D_:$(o\u001c7mKJ\f\u0001c^1uG\"\u001cuN\u001c;s_2dWM\u001d\u0011\u0002\u0011\u00154XM\u001c;CkN,\u0012a\u0011\t\u0003q\u0011K!!\u0012\r\u0003\u001d\rC\u0017M\\4f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%kEc\u0001&L\u0019B\u00111\u0007\u0001\u0005\u0006w\u0019\u0001\u001d!\u0010\u0005\u0006\u0003\u001a\u0001\u001da\u0011\u0005\bm\u0019\u0001\n\u00111\u00018\u0003E!(/Y2l)\u0006\u001c8.\u0012=fGV$xN]\u000b\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\u00111KJ\u0001\u000bG>t7-\u001e:sK:$\u0018BA+S\u0005})\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]*feZL7-Z\u0001\u0013iJ\f7m\u001b+bg.,\u00050Z2vi>\u0014\b%A\u0007uS6,'oU2iK\u0012,H.Z\u000b\u00023B\u0012!\f\u001a\t\u00047\u0002\u0014W\"\u0001/\u000b\u0005Mk&BA\u0017_\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\u001fM\u001b\u0007.\u001a3vY\u0016$g)\u001e;ve\u0016\u0004\"a\u00193\r\u0001\u0011IQmCA\u0001\u0002\u0003\u0015\ta\u001a\u0002\u0004?\u0012\n\u0014A\u0004;j[\u0016\u00148k\u00195fIVdW\rI\t\u0003Q.\u0004\"!J5\n\u0005)4#a\u0002(pi\"Lgn\u001a\t\u0003K1L!!\u001c\u0014\u0003\u0007\u0005s\u00170A\tuS6,'oU2iK\u0012,H.Z0%KF$\"\u0001]:\u0011\u0005\u0015\n\u0018B\u0001:'\u0005\u0011)f.\u001b;\t\u000fQT\u0011\u0011!a\u0001k\u0006\u0019\u0001\u0010J\u00191\u0005YD\bcA.aoB\u00111\r\u001f\u0003\nKN\f\t\u0011!A\u0003\u0002\u001d\fq\u0001Z8Ti\u0006\u0014H\u000fF\u0001q\u0003\u0019!wn\u0015;pa\u00069Am\\\"m_N,\u0017a\u00023p/\u0006$8\r[\u0001\bG>dG.Z2u)\u0011\t\t!a\u0005\u0011\u000b\u0015\n\u0019!a\u0002\n\u0007\u0005\u0015aE\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\r\u0002\u000b5|G-\u001a7\n\t\u0005E\u00111\u0002\u0002\r\u0007\",7m\u001b9pS:$8I\u0016\u0005\b\u0003+\u0001\u0002\u0019AA\f\u0003\u001d!(/Y2l\u0013\u0012\u0004B!!\u0003\u0002\u001a%!\u00111DA\u0006\u0005\u001d!&/Y2l\u0013\u0012D3\u0001AA\u0010!\u0011\t\t#!\f\u000e\u0005\u0005\r\"bA*\u0002&)!\u0011qEA\u0015\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003W\tQA[1wCbLA!a\f\u0002$\tQA\u000b\u001b:fC\u0012\u001c\u0016MZ3\u0002-\u0019c\u0017N\\6DQ\u0016\u001c7\u000e]8j]R<\u0016\r^2iKJ\u0004\"a\r\n\u0014\u0005I!CCAA\u001a\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\b\u0016\u0004o\u0005}2FAA!!\u0011\t\u0019%a\u0013\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001db%\u0003\u0003\u0002N\u0005\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
@ThreadSafe
public class FlinkCheckpointWatcher
implements Logger,
FlinkWatcher {
    private final MetricWatcherConfig conf;
    private final FlinkK8sWatchController watchController;
    private final ChangeEventBus eventBus;
    private final ExecutionContextExecutorService trackTaskExecutor;
    private ScheduledFuture<?> timerSchedule;
    private final AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    private final int org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM;
    private final ScheduledThreadPoolExecutor watchExecutor;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    public static MetricWatcherConfig $lessinit$greater$default$1() {
        return FlinkCheckpointWatcher$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void start() {
        FlinkWatcher.start$(this);
    }

    @Override
    public void stop() {
        FlinkWatcher.stop$(this);
    }

    @Override
    public void close() {
        FlinkWatcher.close$(this);
    }

    @Override
    public void restart() {
        FlinkWatcher.restart$(this);
    }

    @Override
    public Runnable funcToRunnable(Function0<BoxedUnit> fun) {
        return FlinkWatcher.funcToRunnable$(this, fun);
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    @Override
    public AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    }

    @Override
    public int org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM;
    }

    @Override
    public ScheduledThreadPoolExecutor watchExecutor() {
        return this.watchExecutor;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started_$eq(AtomicBoolean x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started = x$1;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM_$eq(int x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM = x$1;
    }

    @Override
    public void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$watchExecutor_$eq(ScheduledThreadPoolExecutor x$1) {
        this.watchExecutor = x$1;
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public FlinkK8sWatchController watchController() {
        return this.watchController;
    }

    public ChangeEventBus eventBus() {
        return this.eventBus;
    }

    private ExecutionContextExecutorService trackTaskExecutor() {
        return this.trackTaskExecutor;
    }

    private ScheduledFuture<?> timerSchedule() {
        return this.timerSchedule;
    }

    private void timerSchedule_$eq(ScheduledFuture<?> x$1) {
        this.timerSchedule = x$1;
    }

    @Override
    public void doStart() {
        this.timerSchedule_$eq(this.watchExecutor().scheduleAtFixedRate(() -> this.doWatch(), 0L, this.conf.requestIntervalSec(), TimeUnit.SECONDS));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkCheckpointWatcher started.");
    }

    @Override
    public void doStop() {
        Object object = !this.timerSchedule().isCancelled() ? BoxesRunTime.boxToBoolean((boolean)this.timerSchedule().cancel(true)) : BoxedUnit.UNIT;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkCheckpointWatcher stopped.");
    }

    @Override
    public void doClose() {
        Object object = Option$.MODULE$.apply(this.timerSchedule()).isDefined() && !this.timerSchedule().isCancelled() ? BoxesRunTime.boxToBoolean((boolean)this.timerSchedule().cancel(true)) : BoxedUnit.UNIT;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkCheckpointWatcher closed.");
    }

    @Override
    public void doWatch() {
        Object object = new Object();
        try {
            Set trackIds = (Set)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.watchController().getActiveWatchingIds()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            Set futures = (Set)trackIds.map((Function1 & Serializable & scala.Serializable)id -> {
                void var2_2;
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.collect((TrackId)id), (ExecutionContext)this.trackTaskExecutor());
                future.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> {
                    FlinkCheckpointWatcher.$anonfun$doWatch$6(this, id, x$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)this.trackTaskExecutor());
                return var2_2;
            }, Set$.MODULE$.canBuildFrom());
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("[FlinkCheckpointWatcher] tracking flink-job checkpoint on kubernetes mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(21).append(" trackingClusterKeys=").append(trackIds$1.mkString(",")).toString()).toString());
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Option<CheckpointCV> collect(TrackId trackId) {
        None$ none$;
        Object object = new Object();
        try {
            if (trackId.jobId() != null) {
                String flinkJmRestUrl = (String)this.watchController().getClusterRestUrl(ClusterKey$.MODULE$.of(trackId)).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlinkCheckpointWatcher.$anonfun$collect$1(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                Checkpoint checkpoint = (Checkpoint)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    Checkpoint c;
                    Option<Checkpoint> option = Checkpoint$.MODULE$.as(Request.get((String)new StringBuilder(18).append(flinkJmRestUrl).append("/jobs/").append(trackId.jobId()).append("/checkpoints").toString()).connectTimeout(KubernetesRetriever$.MODULE$.FLINK_REST_AWAIT_TIMEOUT_SEC()).responseTimeout(KubernetesRetriever$.MODULE$.FLINK_CLIENT_TIMEOUT_SEC()).execute().returnContent().asString(StandardCharsets.UTF_8));
                    if (!(option instanceof Some)) {
                        throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                    }
                    Some some = (Some)option;
                    Checkpoint checkpoint = c = (Checkpoint)some.value();
                    return checkpoint;
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                long x$1 = checkpoint.id();
                String x$2 = checkpoint.externalPath();
                boolean x$3 = checkpoint.isSavepoint();
                String x$42 = checkpoint.checkpointType();
                String x$5 = checkpoint.status();
                long x$6 = checkpoint.triggerTimestamp();
                CheckpointCV checkpointCV = new CheckpointCV(x$1, x$5, x$2, x$3, x$42, x$6);
                none$ = new Some((Object)checkpointCV);
            } else {
                none$ = None$.MODULE$;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$doWatch$6(FlinkCheckpointWatcher $this, TrackId id$1, Try x$2) {
        Option option = (Option)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            CheckpointCV cp = (CheckpointCV)some.value();
            $this.eventBus().postAsync(new FlinkJobCheckpointChangeEvent(id$1, cp));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$collect$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public FlinkCheckpointWatcher(MetricWatcherConfig conf, FlinkK8sWatchController watchController, ChangeEventBus eventBus) {
        this.conf = conf;
        this.watchController = watchController;
        this.eventBus = eventBus;
        Logger.$init$((Logger)this);
        FlinkWatcher.$init$(this);
        this.trackTaskExecutor = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.watchExecutor());
    }
}

