/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.runtime.TupleComparatorBase;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.KeyFieldOutOfBoundsException;
import org.apache.flink.types.NullFieldException;
import org.apache.flink.types.NullKeyFieldException;

@Internal
public final class TupleComparator<T extends Tuple>
extends TupleComparatorBase<T> {
    private static final long serialVersionUID = 1L;

    public TupleComparator(int[] keyPositions, TypeComparator<?>[] comparators, TypeSerializer<?>[] serializers) {
        super(keyPositions, comparators, serializers);
    }

    private TupleComparator(TupleComparator<T> toClone) {
        super(toClone);
    }

    @Override
    public int hash(T value) {
        int i = 0;
        try {
            int code = this.comparators[0].hash(((Tuple)value).getFieldNotNull(this.keyPositions[0]));
            for (i = 1; i < this.keyPositions.length; ++i) {
                code *= HASH_SALT[i & 0x1F];
                code += this.comparators[i].hash(((Tuple)value).getFieldNotNull(this.keyPositions[i]));
            }
            return code;
        }
        catch (NullFieldException nfex) {
            throw new NullKeyFieldException(nfex);
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
    }

    @Override
    public void setReference(T toCompare) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                this.comparators[i].setReference(((Tuple)toCompare).getFieldNotNull(this.keyPositions[i]));
            }
        }
        catch (NullFieldException nfex) {
            throw new NullKeyFieldException(nfex);
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
    }

    @Override
    public boolean equalToReference(T candidate) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                if (this.comparators[i].equalToReference(((Tuple)candidate).getFieldNotNull(this.keyPositions[i]))) continue;
                return false;
            }
            return true;
        }
        catch (NullFieldException nfex) {
            throw new NullKeyFieldException(nfex);
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
    }

    @Override
    public int compare(T first, T second) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                int keyPos = this.keyPositions[i];
                int cmp = this.comparators[i].compare(((Tuple)first).getFieldNotNull(keyPos), ((Tuple)second).getFieldNotNull(keyPos));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (NullFieldException nfex) {
            throw new NullKeyFieldException(nfex);
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
    }

    @Override
    public void putNormalizedKey(T value, MemorySegment target, int offset, int numBytes) {
        int i;
        try {
            for (i = 0; i < this.numLeadingNormalizableKeys && numBytes > 0; ++i) {
                int len = this.normalizedKeyLengths[i];
                len = numBytes >= len ? len : numBytes;
                this.comparators[i].putNormalizedKey(((Tuple)value).getFieldNotNull(this.keyPositions[i]), target, offset, len);
                numBytes -= len;
                offset += len;
            }
        }
        catch (NullFieldException nfex) {
            throw new NullKeyFieldException(nfex);
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyPositions[i]);
        }
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        int localIndex = index;
        for (int i = 0; i < this.comparators.length; ++i) {
            localIndex += this.comparators[i].extractKeys(((Tuple)record).getField(this.keyPositions[i]), target, localIndex);
        }
        return localIndex - index;
    }

    @Override
    public TypeComparator<T> duplicate() {
        return new TupleComparator<T>(this);
    }
}

