/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class OutputTag<T>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String id;
    private final TypeInformation<T> typeInfo;

    public OutputTag(String id) {
        Preconditions.checkNotNull(id, "OutputTag id cannot be null.");
        Preconditions.checkArgument(!id.isEmpty(), "OutputTag id must not be empty.");
        this.id = id;
        try {
            this.typeInfo = TypeExtractor.createTypeInfo(this, OutputTag.class, this.getClass(), 0);
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Could not determine TypeInformation for the OutputTag type. The most common reason is forgetting to make the OutputTag an anonymous inner class. It is also not possible to use generic type variables with OutputTags, such as 'Tuple2<A, B>'.", e);
        }
    }

    public OutputTag(String id, TypeInformation<T> typeInfo) {
        Preconditions.checkNotNull(id, "OutputTag id cannot be null.");
        Preconditions.checkArgument(!id.isEmpty(), "OutputTag id must not be empty.");
        this.id = id;
        this.typeInfo = Preconditions.checkNotNull(typeInfo, "TypeInformation cannot be null.");
    }

    public static boolean isResponsibleFor(@Nullable OutputTag<?> owner, @Nonnull OutputTag<?> other) {
        return other.equals(owner);
    }

    public String getId() {
        return this.id;
    }

    public TypeInformation<T> getTypeInfo() {
        return this.typeInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OutputTag)) {
            return false;
        }
        OutputTag other = (OutputTag)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "OutputTag(" + this.getTypeInfo() + ", " + this.id + ")";
    }
}

