/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;

public class ExpressionLanguageGroovyImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageGroovyImpl.class);
    private static final GroovyShell GROOVY_SHELL = new GroovyShell();
    private final ThreadLocal<ObjectCache<String, Script>> expressionCache = ThreadLocal.withInitial(() -> new ObjectCache<String, Script>(arg_0 -> ((GroovyShell)GROOVY_SHELL).parse(arg_0)));

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating Groovy expression: {1}", expression);
        try {
            Script script = this.expressionCache.get().get(expression);
            Binding binding = new Binding();
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                binding.setVariable(entry.getKey(), entry.getValue());
            }
            script.setBinding(binding);
            return script.run();
        }
        catch (Exception ex) {
            throw new ExpressionEvaluationException("Evaluating script with Groovy failed.", ex);
        }
    }
}

