/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.image.RenderedImage;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;

public final class DeferredProperty {
    private Object value;
    private Function<RenderedImage, ?> provider;

    public DeferredProperty(Function<RenderedImage, ?> provider) {
        this.provider = provider;
    }

    final synchronized Object compute(RenderedImage image) {
        Function<RenderedImage, ?> p;
        if (this.value == null && (p = this.provider) != null) {
            this.provider = null;
            this.value = p.apply(image);
        }
        return this.value;
    }

    public static Map<String, Object> forGridGeometry(GridGeometry grid, int[] dimensions) {
        return Map.of("org.apache.sis.GridGeometry", new DeferredProperty(new ImageGeometry(grid, dimensions)));
    }

    private static final class ImageGeometry
    implements Function<RenderedImage, GridGeometry> {
        private final GridGeometry grid;
        private final int dimX;
        private final int dimY;

        public ImageGeometry(GridGeometry grid, int[] dimensions) {
            this.grid = grid;
            this.dimX = dimensions[0];
            this.dimY = dimensions[1];
        }

        @Override
        public GridGeometry apply(RenderedImage image) {
            GridExtent extent = this.grid.getExtent();
            return this.grid.selectDimensions(this.dimX, this.dimY).shiftGrid(Math.subtractExact((long)image.getMinX(), extent.getLow(this.dimX)), Math.subtractExact((long)image.getMinY(), extent.getLow(this.dimY)));
        }
    }
}

