/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class DateDiffStep<S>
extends ScalarMapStep<S, Long>
implements TraversalParent {
    private Date value;
    private Traversal.Admin<S, Date> dateTraversal;

    public DateDiffStep(Traversal.Admin traversal, Date value) {
        super(traversal);
        this.value = value;
    }

    public DateDiffStep(Traversal.Admin traversal, Traversal<?, Date> dateTraversal) {
        super(traversal);
        this.dateTraversal = this.integrateChild(dateTraversal.asAdmin());
    }

    @Override
    protected Long map(Traverser.Admin<S> traverser) {
        Object object = traverser.get();
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException(String.format("DateDiff can only take Date as argument, encountered %s", object.getClass()));
        }
        Date otherDate = this.value != null ? this.value : (this.dateTraversal != null ? TraversalUtil.apply(traverser, this.dateTraversal) : null);
        long otherDateMs = otherDate == null ? 0L : otherDate.getTime();
        return (((Date)object).getTime() - otherDateMs) / 1000L;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : this.dateTraversal.hashCode());
        return result;
    }

    @Override
    public DateDiffStep<S> clone() {
        DateDiffStep clone = (DateDiffStep)super.clone();
        clone.value = this.value;
        clone.dateTraversal = this.dateTraversal;
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }

    public Date getValue() {
        return this.value;
    }

    public Traversal.Admin<S, Date> getDateTraversal() {
        return this.dateTraversal;
    }
}

