/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import jakarta.enterprise.context.RequestScoped;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.context.WebContextsService;
import org.apache.webbeans.web.util.ServletCompatibilityUtil;

public class WebBeansConfigurationFilter
implements Filter {
    private static final String CALL_COUNT_ATTRIBUTE_NAME = WebBeansConfigurationFilter.class.getName();
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansConfigurationFilter.class);
    protected ContainerLifecycle lifeCycle;
    private WebBeansContext webBeansContext = WebBeansContext.getInstance();
    private ServletContext servletContext;
    private WebContextsService webContextsService = (WebContextsService)this.webBeansContext.getContextsService();
    private boolean startOwb;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.lifeCycle = (ContainerLifecycle)this.webBeansContext.getService(ContainerLifecycle.class);
        this.servletContext = filterConfig.getServletContext();
        String startOwbCfg = filterConfig.getInitParameter("startOwb");
        boolean bl = this.startOwb = startOwbCfg == null || "true".equalsIgnoreCase(startOwbCfg);
        if (this.startOwb) {
            try {
                this.lifeCycle.startApplication((Object)new ServletContextEvent(this.servletContext));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0018", (Object[])new Object[]{ServletCompatibilityUtil.getServletInfo(this.servletContext)}));
                WebBeansUtil.throwRuntimeExceptions((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            if (this.firstInit(servletRequest)) {
                this.requestInitialized(servletRequest);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (this.lastDestroy(servletRequest)) {
                this.requestDestroyed(servletRequest);
            }
        }
    }

    private boolean firstInit(ServletRequest servletRequest) {
        Integer callCount = (Integer)servletRequest.getAttribute(CALL_COUNT_ATTRIBUTE_NAME);
        if (callCount == null) {
            callCount = 0;
        }
        Integer n = callCount;
        Integer n2 = callCount = Integer.valueOf(callCount + 1);
        servletRequest.setAttribute(CALL_COUNT_ATTRIBUTE_NAME, (Object)callCount);
        return callCount == 1;
    }

    private boolean lastDestroy(ServletRequest servletRequest) {
        Integer callCount;
        Integer n = callCount = (Integer)servletRequest.getAttribute(CALL_COUNT_ATTRIBUTE_NAME);
        Integer n2 = callCount = Integer.valueOf(callCount - 1);
        servletRequest.setAttribute(CALL_COUNT_ATTRIBUTE_NAME, (Object)callCount);
        return callCount == 0;
    }

    public void requestInitialized(ServletRequest servletRequest) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a new request : [{0}]", servletRequest.getRemoteAddr());
            }
            this.lifeCycle.getContextService().startContext(RequestScoped.class, (Object)new ServletRequestEvent(this.servletContext, servletRequest));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0019", (Object[])new Object[]{servletRequest}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void requestDestroyed(ServletRequest request) {
        ELContextStore elStore;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a request : [{0}]", request.getRemoteAddr());
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        this.lifeCycle.getContextService().endContext(RequestScoped.class, (Object)new ServletRequestEvent(this.servletContext, request));
        this.cleanupRequestThreadLocals();
    }

    public void destroy() {
        if (this.startOwb) {
            this.lifeCycle.stopApplication((Object)new ServletContextEvent(this.servletContext));
            this.lifeCycle = null;
            this.servletContext = null;
            this.cleanupRequestThreadLocals();
        }
    }

    private void cleanupRequestThreadLocals() {
        this.webContextsService.removeThreadLocals();
    }
}

