/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.util;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.BatchRuntime;
import jakarta.batch.runtime.BatchStatus;
import java.util.Arrays;
import java.util.Collection;
import org.apache.batchee.container.impl.JobOperatorImpl;

public class Batches {
    private static final Collection<BatchStatus> BATCH_END_STATUSES = Arrays.asList(BatchStatus.COMPLETED, BatchStatus.FAILED, BatchStatus.STOPPED, BatchStatus.ABANDONED);

    private Batches() {
    }

    public static void waitForEnd(long id) {
        Batches.waitForEnd(BatchRuntime.getJobOperator(), id);
    }

    public static void waitForEnd(JobOperator jobOperator, long id) {
        Batches.waitFor(jobOperator, id);
    }

    public static BatchStatus waitFor(long id) {
        return Batches.waitFor(BatchRuntime.getJobOperator(), id);
    }

    public static BatchStatus waitFor(JobOperator jobOperator, long id) {
        BatchStatus batchStatus;
        if (JobOperatorImpl.class.isInstance(jobOperator)) {
            ((JobOperatorImpl)JobOperatorImpl.class.cast(jobOperator)).waitFor(id);
            batchStatus = Batches.getBatchStatus(jobOperator, id);
        } else {
            do {
                try {
                    Thread.sleep(100L);
                    batchStatus = Batches.getBatchStatus(jobOperator, id);
                }
                catch (InterruptedException e) {
                    return Batches.getBatchStatus(jobOperator, id);
                }
            } while (!Batches.isDone(batchStatus));
        }
        return batchStatus;
    }

    public static boolean isDone(BatchStatus status) {
        return BATCH_END_STATUSES.contains(status);
    }

    public static boolean isDone(JobOperator jobOperator, long id) {
        return Batches.isDone(Batches.getBatchStatus(jobOperator, id));
    }

    private static BatchStatus getBatchStatus(JobOperator jobOperator, long id) {
        return jobOperator.getJobExecution(id).getBatchStatus();
    }
}

