/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.ContainerTransaction;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.InterceptorBinding;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;

class RemoveWebServices
implements DynamicDeployer {
    RemoveWebServices() {
    }

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            Map deployments = openejbJar.getDeploymentsByEjbName();
            for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
                SessionBean sessionBean;
                String ejbName = enterpriseBean.getEjbName();
                EjbDeployment ejbDeployment = (EjbDeployment)deployments.get(ejbName);
                enterpriseBean.getServiceRef().clear();
                if (!(enterpriseBean instanceof SessionBean) || (sessionBean = (SessionBean)enterpriseBean).getServiceEndpoint() == null) continue;
                sessionBean.setServiceEndpoint(null);
                if (sessionBean.getHome() != null || sessionBean.getLocalHome() != null || sessionBean.getBusinessLocal().size() > 0 || sessionBean.getBusinessRemote().size() > 0) continue;
                ejbJar.removeEnterpriseBean(ejbName);
                openejbJar.removeEjbDeployment(ejbDeployment);
                AssemblyDescriptor assemblyDescriptor = ejbJar.getAssemblyDescriptor();
                if (assemblyDescriptor == null) continue;
                for (MethodPermission permission : this.copy(assemblyDescriptor.getMethodPermission())) {
                    for (Method method : this.copy(permission.getMethod())) {
                        if (!method.getEjbName().equals(ejbName)) continue;
                        permission.getMethod().remove(method);
                    }
                    if (permission.getMethod().size() != 0) continue;
                    assemblyDescriptor.getMethodPermission().remove(permission);
                }
                for (ContainerTransaction transaction : this.copy(assemblyDescriptor.getContainerTransaction())) {
                    for (Method method : this.copy(transaction.getMethod())) {
                        if (!method.getEjbName().equals(ejbName)) continue;
                        transaction.getMethod().remove(method);
                    }
                    if (transaction.getMethod().size() != 0) continue;
                    assemblyDescriptor.getContainerTransaction().remove(transaction);
                }
                for (InterceptorBinding binding : this.copy(assemblyDescriptor.getInterceptorBinding())) {
                    if (!binding.getEjbName().equals(ejbName)) continue;
                    assemblyDescriptor.getInterceptorBinding().remove(binding);
                }
            }
            for (EnterpriseBean enterpriseBean : ejbJar.getInterceptors()) {
                enterpriseBean.getServiceRef().clear();
            }
        }
        return appModule;
    }

    public <T> List<T> copy(Collection<T> list) {
        return new ArrayList<T>(list);
    }
}

