/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.pem;

import io.churchkey.Key;
import io.churchkey.asn1.Asn1Object;
import io.churchkey.asn1.Asn1Type;
import io.churchkey.asn1.DerParser;
import io.churchkey.asn1.DerWriter;
import io.churchkey.asn1.Oid;
import io.churchkey.dsa.Dsa;
import io.churchkey.ec.Curve;
import io.churchkey.ec.EcPoints;
import io.churchkey.ec.Ecdsa;
import io.churchkey.ec.UnsupportedCurveException;
import io.churchkey.pem.EcCurveParams;
import io.churchkey.rsa.Rsa;
import io.churchkey.util.Bytes;
import io.churchkey.util.Pem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;

public class BeginPrivateKey {
    private static final Oid rsaKey = Oid.fromString("1.2.840.113549.1.1.1");
    private static final Oid dsaKey = Oid.fromString("1.2.840.10040.4.1");
    private static final Oid ecKey = Oid.fromString("1.2.840.10045.2.1");

    private BeginPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            Oid keyTypeOid = BeginPrivateKey.readKeyType(bytes);
            if (rsaKey.equals(keyTypeOid)) {
                return BeginPrivateKey.decodeRsaKey(bytes);
            }
            if (dsaKey.equals(keyTypeOid)) {
                return BeginPrivateKey.decodeDsaKey(bytes);
            }
            if (ecKey.equals(keyTypeOid)) {
                return BeginPrivateKey.decodeEcKey(bytes);
            }
            throw new UnsupportedOperationException("Unsupported key type oid: " + keyTypeOid);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Key decodeRsaKey(byte[] bytes) throws IOException {
        DerParser d1 = new DerParser(bytes);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        Asn1Object asn1Object = d3.readObject().assertType(Asn1Type.NULL);
        Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
        DerParser d32 = new DerParser(d2o3.getValue());
        Asn1Object d3o12 = d32.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d4 = new DerParser(d3o12.getValue());
        BigInteger version = d4.readBigInteger();
        Rsa.Private build = Rsa.Private.builder().modulus(d4.readBigInteger()).publicExponent(d4.readBigInteger()).privateExponent(d4.readBigInteger()).primeP(d4.readBigInteger()).primeQ(d4.readBigInteger()).primeExponentP(d4.readBigInteger()).primeExponentQ(d4.readBigInteger()).crtCoefficient(d4.readBigInteger()).build();
        RSAPrivateCrtKey privateKey = build.toKey();
        RSAPublicKey publicKey = build.toPublic().toKey();
        return new Key((java.security.Key)privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
    }

    private static Key decodeDsaKey(byte[] bytes) throws IOException {
        Dsa.Private.Builder dsa = Dsa.Private.builder();
        DerParser d1 = new DerParser(bytes);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        Asn1Object d3o2 = d3.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d4 = new DerParser(d3o2.getValue());
        dsa.p(d4.readBigInteger());
        dsa.q(d4.readBigInteger());
        dsa.g(d4.readBigInteger());
        Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
        DerParser d32 = new DerParser(d2o3.getValue());
        dsa.x(d32.readBigInteger());
        Dsa.Private build = dsa.build();
        DSAPrivateKey privateKey = build.toKey();
        DSAPublicKey publicKey = build.toPublic().toKey();
        return new Key((java.security.Key)privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
    }

    private static Key decodeEcKey(byte[] bytes) throws IOException {
        Ecdsa.Private.Builder ecdsa = Ecdsa.Private.builder();
        DerParser d1 = new DerParser(bytes);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        Asn1Object d3o2 = d3.readObject();
        if (d3o2.isType(Asn1Type.OBJECT_IDENTIFIER)) {
            Oid oid = d3o2.asOID();
            Curve curve = Curve.resolve(oid);
            if (curve == null) {
                throw new UnsupportedCurveException(oid.toString());
            }
            ecdsa.curve(curve);
        } else if (d3o2.isType(Asn1Type.SEQUENCE)) {
            ECParameterSpec parameterSpec = EcCurveParams.parseSequence(d3o2);
            ecdsa.spec(parameterSpec);
        }
        Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
        DerParser d32 = new DerParser(d2o3.getValue());
        Asn1Object d3o12 = d32.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d4 = new DerParser(d3o12.getValue());
        Asn1Object d4o1 = d4.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d4o2 = d4.readObject().assertType(Asn1Type.OCTET_STRING);
        Asn1Object d4o3 = d4.readObject();
        if (d4o3 != null && d4o3.isType(Asn1Type.BOOLEAN)) {
            DerParser d5 = new DerParser(d4o3.getValue());
            Asn1Object d5o1 = d5.readObject().assertType(Asn1Type.BIT_STRING);
            byte[] value = Bytes.trim(d5o1.getValue());
            ECPoint ecPoint = EcPoints.fromBytes(value);
            ecdsa.x(ecPoint.getAffineX());
            ecdsa.y(ecPoint.getAffineY());
        }
        ecdsa.d(new BigInteger(1, Bytes.trim(d4o2.getValue())));
        Ecdsa.Private build = ecdsa.build();
        ECPrivateKey privateKey = build.toKey();
        ECPublicKey publicKey = build.getX() != null && build.getY() != null ? build.toPublic().toKey() : null;
        return new Key((java.security.Key)privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.PEM);
    }

    private static Oid readKeyType(byte[] bytes) throws IOException {
        DerParser d1 = new DerParser(bytes);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        return d3o1.asOID();
    }

    public static byte[] encode(Key key) {
        byte[] derEncodedBytes = BeginPrivateKey.toDer(key);
        return Pem.builder().type("PRIVATE KEY").data(derEncodedBytes).wrap(64).format().getBytes();
    }

    public static byte[] toDer(Key key) {
        if (key.getAlgorithm() == Key.Algorithm.RSA) {
            RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)key.getKey();
            return BeginPrivateKey.encodeRsa(privateKey);
        }
        if (key.getAlgorithm() == Key.Algorithm.DSA) {
            DSAPrivateKey privateKey = (DSAPrivateKey)key.getKey();
            return BeginPrivateKey.encodeDsa(privateKey);
        }
        if (key.getAlgorithm() == Key.Algorithm.EC) {
            return BeginPrivateKey.encodeEc(key);
        }
        return null;
    }

    private static byte[] encodeDsa(DSAPrivateKey privateKey) {
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ZERO).sequence(DerWriter.write().objectIdentifier(dsaKey).sequence(DerWriter.write().integer(privateKey.getParams().getP()).integer(privateKey.getParams().getQ()).integer(privateKey.getParams().getG()))).octetString(DerWriter.write().integer(privateKey.getX()))).bytes();
    }

    private static byte[] encodeRsa(RSAPrivateCrtKey privateKey) {
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ZERO).sequence(DerWriter.write().objectIdentifier(rsaKey).nill()).octetString(DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ZERO).integer(privateKey.getModulus()).integer(privateKey.getPublicExponent()).integer(privateKey.getPrivateExponent()).integer(privateKey.getPrimeP()).integer(privateKey.getPrimeQ()).integer(privateKey.getPrimeExponentP()).integer(privateKey.getPrimeExponentQ()).integer(privateKey.getCrtCoefficient())))).bytes();
    }

    private static byte[] encodeEc(Key key) {
        ECPrivateKey privateKey = (ECPrivateKey)key.getKey();
        ECParameterSpec params = privateKey.getParams();
        Curve curve = Arrays.stream(Curve.values()).filter(c -> c.isEqual(params)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to resolve OID for ECParameterSpec"));
        if (key.getPublicKey() != null) {
            ECPublicKey publicKey = (ECPublicKey)key.getPublicKey().getKey();
            return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ZERO).sequence(DerWriter.write().objectIdentifier(ecKey).objectIdentifier(curve.getOid())).octetString(DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ONE).octetString(privateKey.getS()).bolean(DerWriter.write().bitString(EcPoints.toBytes(publicKey.getW())))))).bytes();
        }
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ZERO).sequence(DerWriter.write().objectIdentifier(ecKey).objectIdentifier(curve.getOid())).octetString(DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ONE).octetString(privateKey.getS())))).bytes();
    }
}

