/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import javax.annotation.Nonnull;
import org.opensaml.xmlsec.encryption.CipherData;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.EncryptedType;
import org.opensaml.xmlsec.encryption.support.PreDecryptionValidationException;
import org.opensaml.xmlsec.encryption.support.PreDecryptionValidator;

public class DefaultPreDecryptionValidator
implements PreDecryptionValidator {
    @Override
    public void validate(@Nonnull EncryptedData encryptedData) throws PreDecryptionValidationException {
        this.performCommonValidation(encryptedData);
    }

    @Override
    public void validate(@Nonnull EncryptedKey encryptedKey) throws PreDecryptionValidationException {
        this.performCommonValidation(encryptedKey);
    }

    protected void performCommonValidation(@Nonnull EncryptedType encryptedType) throws PreDecryptionValidationException {
        CipherData data = encryptedType.getCipherData();
        if (data == null) {
            throw new PreDecryptionValidationException(String.format("%s contains no CipherData child element, which is mandatory", encryptedType.getClass().getSimpleName()));
        }
        if (data.getCipherReference() != null) {
            throw new PreDecryptionValidationException(String.format("%s contains a CipherReference, which is not allowed", encryptedType.getClass().getSimpleName()));
        }
    }
}

