/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.AnnotationTypeExpression;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.type.RutaBasic;

public class RutaAnnotationTypeMatcher
implements RutaMatcher {
    private static final boolean CHECK_ON_FEATURE = true;
    private AnnotationTypeExpression expression;

    public RutaAnnotationTypeMatcher(AnnotationTypeExpression expression) {
        this.expression = expression;
    }

    @Override
    public Collection<? extends AnnotationFS> getMatchingAnnotations(RutaBlock parent, RutaStream stream) {
        MatchContext context = new MatchContext(parent);
        this.expression.getType(context, stream);
        if (this.expression.getAnnotationListExpression() != null) {
            List<AnnotationFS> result = this.expression.getAnnotationList(context, stream);
            return result != null ? result : Collections.emptyList();
        }
        if (this.expression.getAnnotationExpression() != null) {
            return Arrays.asList(this.expression.getAnnotation(context, stream));
        }
        List<Type> types = this.expression.getTypeListExpression() != null ? this.expression.getTypeListExpression().getTypeList(context, stream) : Arrays.asList(this.getType(context.getParent(), stream));
        Collection<Object> result = new ArrayList<AnnotationFS>();
        for (Type type : types) {
            if (type == null) continue;
            Type overallDAType = stream.getCas().getDocumentAnnotation().getType();
            String name = type.getName();
            if ("uima.tcas.DocumentAnnotation".equals(name) || "org.apache.uima.ruta.type.Document".equals(name) || overallDAType.equals(type)) {
                result.add(stream.getDocumentAnnotation());
            } else {
                result.addAll(stream.getAnnotations(type));
            }
            if (this.expression.getFeatureExpression() == null) continue;
            Collection<? extends AnnotationFS> r = this.expression.getFeatureExpression().getAnnotations(result, true, context, stream);
            result = r;
        }
        return result;
    }

    @Override
    public Collection<? extends AnnotationFS> getAnnotationsAfter(RutaRuleElement ruleElement, AnnotationFS annotation, RutaBlock parent, RutaStream stream) {
        if (annotation.getEnd() == stream.getDocumentAnnotation().getEnd()) {
            return Collections.emptyList();
        }
        RutaBasic nextBasic = stream.getBasicNextTo(false, annotation);
        if (nextBasic == null) {
            return Collections.emptyList();
        }
        MatchContext context = new MatchContext(parent);
        this.expression.getType(context, stream);
        if (this.expression.getAnnotationExpression() != null) {
            AnnotationFS ref = this.expression.getAnnotation(context, stream);
            if (ref != null) {
                boolean beginsWith;
                boolean bl = beginsWith = nextBasic.getBegin() == ref.getBegin();
                if (beginsWith) {
                    ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>(1);
                    result.add(ref);
                    return result;
                }
            }
        } else {
            if (this.expression.getAnnotationListExpression() != null) {
                List<AnnotationFS> annotations = this.expression.getAnnotationList(context, stream);
                ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
                for (AnnotationFS each : annotations) {
                    boolean beginsWith = nextBasic.getBegin() == each.getBegin();
                    if (!beginsWith) continue;
                    result.add(each);
                }
                return result;
            }
            List<Type> types = null;
            if (this.expression.getTypeListExpression() != null) {
                types = this.expression.getTypeListExpression().getTypeList(context, stream);
            } else {
                Type type = this.getType(context.getParent(), stream);
                types = new ArrayList<Type>(1);
                types.add(type);
            }
            ArrayList<Object> annotations = new ArrayList<Object>();
            for (Type type : types) {
                ArrayList<AnnotationFS> anchors = new ArrayList<AnnotationFS>();
                Collection beginAnchors = nextBasic.getBeginAnchors(type);
                if (beginAnchors != null) {
                    for (AnnotationFS afs : beginAnchors) {
                        if (afs.getBegin() < stream.getDocumentAnnotation().getBegin() || afs.getEnd() > stream.getDocumentAnnotation().getEnd()) continue;
                        anchors.add(afs);
                    }
                }
                if (this.expression.getFeatureExpression() != null) {
                    annotations.addAll(this.expression.getFeatureExpression().getAnnotations(anchors, true, context, stream));
                    continue;
                }
                annotations.addAll(anchors);
            }
            return annotations;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends AnnotationFS> getAnnotationsBefore(RutaRuleElement ruleElement, AnnotationFS annotation, RutaBlock parent, RutaStream stream) {
        if (annotation.getBegin() == stream.getDocumentAnnotation().getBegin()) {
            return Collections.emptyList();
        }
        RutaBasic nextBasic = stream.getBasicNextTo(true, annotation);
        if (nextBasic == null) {
            return Collections.emptyList();
        }
        MatchContext context = new MatchContext(parent);
        this.expression.getType(context, stream);
        if (this.expression.getAnnotationExpression() != null) {
            boolean endsWith;
            AnnotationFS ref = this.expression.getAnnotationExpression().getAnnotation(context, stream);
            boolean bl = endsWith = nextBasic.getEnd() == ref.getEnd();
            if (endsWith) {
                ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>(1);
                result.add(ref);
                return result;
            }
        } else if (this.expression.getAnnotationListExpression() != null) {
            List<AnnotationFS> annotations = this.expression.getAnnotationListExpression().getAnnotationList(context, stream);
            for (AnnotationFS each : annotations) {
                boolean endsWith = nextBasic.getEnd() == each.getEnd();
                if (!endsWith) continue;
                ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
                result.add(each);
                return result;
            }
        } else {
            List<Type> types = null;
            if (this.expression.getTypeListExpression() != null) {
                types = this.expression.getTypeListExpression().getTypeList(context, stream);
            } else {
                Type type = this.getType(context.getParent(), stream);
                types = new ArrayList<Type>(1);
                types.add(type);
            }
            ArrayList<Object> annotations = new ArrayList<Object>();
            for (Type type : types) {
                ArrayList<AnnotationFS> anchors = new ArrayList<AnnotationFS>();
                Collection endAnchors = nextBasic.getEndAnchors(type);
                if (endAnchors != null) {
                    for (AnnotationFS afs : endAnchors) {
                        if (afs.getBegin() < stream.getDocumentAnnotation().getBegin()) continue;
                        anchors.add(afs);
                    }
                }
                if (this.expression.getFeatureExpression() != null) {
                    annotations.addAll(this.expression.getFeatureExpression().getAnnotations(anchors, true, context, stream));
                    continue;
                }
                annotations.addAll(anchors);
            }
            return annotations;
        }
        return Collections.emptyList();
    }

    public String toString() {
        IRutaExpression expression = this.getExpression();
        if (expression != null) {
            return expression.toString();
        }
        return "";
    }

    @Override
    public IRutaExpression getExpression() {
        return this.expression;
    }

    protected Type getType(AnnotationTypeExpression expression, RutaBlock parent, RutaStream stream, boolean resolveDocumentAnnotation) {
        MatchContext context = new MatchContext(parent);
        Type type = expression.getType(context, stream);
        if (resolveDocumentAnnotation && type != null && StringUtils.equals((CharSequence)"uima.tcas.DocumentAnnotation", (CharSequence)type.getName())) {
            return stream.getDocumentAnnotationType();
        }
        return type;
    }

    @Override
    public long estimateAnchors(RutaBlock parent, RutaStream stream) {
        if (this.expression.getAnnotationExpression() != null) {
            return 1L;
        }
        if (this.expression.getAnnotationListExpression() != null) {
            return 1L;
        }
        return stream.getHistogram(this.getType(this.expression, parent, stream, true));
    }

    @Override
    public Type getType(RutaBlock parent, RutaStream stream) {
        MatchContext context = new MatchContext(parent);
        if (this.expression.getAnnotationExpression() != null) {
            AnnotationFS annotation = this.expression.getAnnotationExpression().getAnnotation(context, stream);
            if (annotation != null) {
                return annotation.getType();
            }
        } else {
            if (this.expression.getAnnotationListExpression() != null) {
                List<AnnotationFS> annotations = this.expression.getAnnotationListExpression().getAnnotationList(context, stream);
                ArrayList<Type> types = new ArrayList<Type>();
                for (AnnotationFS each : annotations) {
                    types.add(each.getType());
                }
                return stream.getSharedParentType(types);
            }
            return this.getType(this.expression, parent, stream, false);
        }
        return null;
    }
}

