; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -global-isel-abort=1 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK-GI

; Checks generated libcalls for fp128 types

define double @oeq(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: oeq:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __eqtf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, eq
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: oeq:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __eqtf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, eq
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp oeq fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @ogt(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: ogt:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, gt
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ogt:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, gt
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp ogt fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @olt(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: olt:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __lttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, lt
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: olt:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, lt
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp olt fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @ole(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: ole:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __letf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, le
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ole:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __letf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, le
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp ole fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @one(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: one:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    stp q0, q1, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    bl __eqtf2
; CHECK-SD-NEXT:    ldp q0, q1, [sp] // 32-byte Folded Reload
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    cset w19, ne
; CHECK-SD-NEXT:    bl __unordtf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    cset w8, eq
; CHECK-SD-NEXT:    tst w8, w19
; CHECK-SD-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, ne
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: one:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    stp q1, q0, [sp] // 32-byte Folded Spill
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __eqtf2
; CHECK-GI-NEXT:    ldp q1, q0, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov w19, w0
; CHECK-GI-NEXT:    bl __unordtf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ccmp w19, #0, #4, eq
; CHECK-GI-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, ne
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp one fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @ord(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: ord:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __unordtf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, eq
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ord:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __unordtf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, eq
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp ord fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @uno(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: uno:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __unordtf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, ne
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: uno:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __unordtf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, ne
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp uno fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @ueq(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: ueq:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    stp q0, q1, [sp] // 32-byte Folded Spill
; CHECK-SD-NEXT:    bl __eqtf2
; CHECK-SD-NEXT:    ldp q0, q1, [sp] // 32-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __unordtf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ccmp w19, #0, #4, eq
; CHECK-SD-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, eq
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ueq:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    stp q1, q0, [sp] // 32-byte Folded Spill
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __eqtf2
; CHECK-GI-NEXT:    ldp q1, q0, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov w19, w0
; CHECK-GI-NEXT:    bl __unordtf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ccmp w19, #0, #4, eq
; CHECK-GI-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, eq
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp ueq fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @ugt(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: ugt:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __letf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, gt
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ugt:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __letf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, gt
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp ugt fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @uge(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: uge:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __lttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, ge
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: uge:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, ge
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp uge fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @ult(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: ult:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, lt
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ult:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __getf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, lt
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp ult fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @ule(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: ule:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, le
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ule:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, le
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp ule fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

define double @une(fp128 %a, fp128 %b, double %d, double %e) {
; CHECK-SD-LABEL: une:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    .cfi_offset b8, -24
; CHECK-SD-NEXT:    .cfi_offset b9, -32
; CHECK-SD-NEXT:    fmov d8, d3
; CHECK-SD-NEXT:    fmov d9, d2
; CHECK-SD-NEXT:    bl __netf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    fcsel d0, d9, d8, ne
; CHECK-SD-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: une:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 32
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    .cfi_offset b8, -24
; CHECK-GI-NEXT:    .cfi_offset b9, -32
; CHECK-GI-NEXT:    fmov d8, d2
; CHECK-GI-NEXT:    fmov d9, d3
; CHECK-GI-NEXT:    bl __netf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    fcsel d0, d8, d9, ne
; CHECK-GI-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %c = fcmp une fp128 %a, %b
  %s = select i1 %c, double %d, double %e
  ret double %s
}

