; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='early-cse<memssa>' -S %s | FileCheck %s

declare void @foo(ptr)

define ptr @align_replacement_does_not_have_align_metadata(ptr noalias %p) {
; CHECK-LABEL: define ptr @align_replacement_does_not_have_align_metadata(
; CHECK-SAME: ptr noalias [[P:%.*]]) {
; CHECK-NEXT:    [[L_1:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    call void @foo(ptr [[L_1]])
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[L_1]], i64 4
; CHECK-NEXT:    store ptr [[GEP]], ptr [[P]], align 8
; CHECK-NEXT:    ret ptr [[GEP]]
;
  %l.1 = load ptr, ptr %p, align 8
  call void @foo(ptr %l.1)
  %l.2 = load ptr, ptr %p, align 8
  %gep = getelementptr i8, ptr %l.2, i64 4
  store ptr %gep, ptr %p, align 8
  %l.3 = load ptr, ptr %p, align 8, !align !0
  ret ptr %l.3
}

define ptr @align_replacement_does_not_have_align_metadata2(ptr noalias %p) {
; CHECK-LABEL: define ptr @align_replacement_does_not_have_align_metadata2(
; CHECK-SAME: ptr noalias [[P:%.*]]) {
; CHECK-NEXT:    [[L_1:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[L_1]], i64 4
; CHECK-NEXT:    store ptr [[GEP]], ptr [[P]], align 8
; CHECK-NEXT:    ret ptr [[GEP]]
;
  %l.1 = load ptr, ptr %p, align 8
  %gep = getelementptr i8, ptr %l.1, i64 4
  store ptr %gep, ptr %p, align 8
  %l.2 = load ptr, ptr %p, align 8, !align !0
  ret ptr %l.2
}

define ptr @align_replacement_has_same_alignment(ptr noalias %p) {
; CHECK-LABEL: define ptr @align_replacement_has_same_alignment(
; CHECK-SAME: ptr noalias [[P:%.*]]) {
; CHECK-NEXT:    [[L_1:%.*]] = load ptr, ptr [[P]], align 8, !align [[META0:![0-9]+]]
; CHECK-NEXT:    call void @foo(ptr [[L_1]])
; CHECK-NEXT:    ret ptr [[L_1]]
;
  %l.1 = load ptr, ptr %p, align 8, !align !0
  call void @foo(ptr %l.1)
  %l.2 = load ptr, ptr %p, align 8, !align !0
  ret ptr %l.2
}

define ptr @align_replacement_has_smaller_alignment(ptr noalias %p) {
; CHECK-LABEL: define ptr @align_replacement_has_smaller_alignment(
; CHECK-SAME: ptr noalias [[P:%.*]]) {
; CHECK-NEXT:    [[L_1:%.*]] = load ptr, ptr [[P]], align 8, !align [[META0]]
; CHECK-NEXT:    call void @foo(ptr [[L_1]])
; CHECK-NEXT:    ret ptr [[L_1]]
;
  %l.1 = load ptr, ptr %p, align 8, !align !0
  call void @foo(ptr %l.1)
  %l.2 = load ptr, ptr %p, align 8, !align !1
  ret ptr %l.2
}

define ptr @align_replacement_has_larger_alignment(ptr %p) {
; CHECK-LABEL: define ptr @align_replacement_has_larger_alignment(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:    [[L_1:%.*]] = load ptr, ptr [[P]], align 8, !align [[META1:![0-9]+]]
; CHECK-NEXT:    call void @foo(ptr [[L_1]])
; CHECK-NEXT:    [[L_2:%.*]] = load ptr, ptr [[P]], align 8, !align [[META0]]
; CHECK-NEXT:    ret ptr [[L_2]]
;
  %l.1 = load ptr, ptr %p, align 8, !align !1
  call void @foo(ptr %l.1)
  %l.2 = load ptr, ptr %p, align 8, !align !0
  ret ptr %l.2
}

define ptr @align_1(ptr %p) {
; CHECK-LABEL: define ptr @align_1(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:    [[L_1:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    call void @foo(ptr [[L_1]])
; CHECK-NEXT:    [[L_2:%.*]] = load ptr, ptr [[P]], align 8, !align [[META2:![0-9]+]]
; CHECK-NEXT:    ret ptr [[L_2]]
;
  %l.1 = load ptr, ptr %p, align 8
  call void @foo(ptr %l.1)
  %l.2 = load ptr, ptr %p, align 8, !align !2
  ret ptr %l.2
}

!0 = !{i64 4}
!1 = !{i64 8}
!2 = !{i64 1}
;.
; CHECK: [[META0]] = !{i64 4}
; CHECK: [[META1]] = !{i64 8}
; CHECK: [[META2]] = !{i64 1}
;.
