/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;

public abstract class AbstractService
implements IService {
    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            result.addAll((Collection<IType>)entry.getValue());
        }
        return result;
    }

    @Override
    public Object invoke(Object ... arguments) throws AcceleoQueryEvaluationException {
        Object result;
        try {
            result = this.internalInvoke(arguments);
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(String.valueOf(this.getShortSignature()) + " with arguments " + Arrays.deepToString(arguments) + " failed.", e);
        }
        return result;
    }

    protected abstract Object internalInvoke(Object[] var1) throws Exception;

    protected String serviceShortSignature(Object[] argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append('(');
        boolean first = true;
        Object[] objectArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object argType = objectArray[n2];
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            if (argType instanceof Class) {
                builder.append(((Class)argType).getCanonicalName());
            } else if (argType instanceof EClass) {
                builder.append("EClass=" + ((EClass)argType).getName());
            } else if (argType == null) {
                builder.append("Object=null");
            } else {
                builder.append("Object=" + argType.toString());
            }
            ++n2;
        }
        return builder.append(')').toString();
    }
}

