/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.basic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;

public class CacheLookupEngine
extends BasicLookupEngine {
    private static final IService NO_SERVICE = new JavaMethodService(null, null);
    private final Map<String, Node> cache = new HashMap<String, Node>();

    public CacheLookupEngine(IReadOnlyQueryEnvironment queryEnvironment, CrossReferenceProvider crossReferencer) {
        super(queryEnvironment, crossReferencer);
    }

    @Override
    public ServiceRegistrationResult registerServices(Class<?> newServices) throws InvalidAcceleoPackageException {
        this.cache.clear();
        return super.registerServices(newServices);
    }

    @Override
    public IService lookup(String name, Class<?>[] argumentTypes) {
        IService result;
        Node cachedNode = this.getNodeFromCache(name, argumentTypes);
        if (cachedNode != null) {
            if (cachedNode.service == NO_SERVICE) {
                result = null;
            } else if (cachedNode.service == null) {
                result = super.lookup(name, argumentTypes);
                cachedNode.service = result;
            } else {
                result = cachedNode.service;
            }
        } else {
            result = super.lookup(name, argumentTypes);
            this.cacheService(name, argumentTypes, result);
        }
        return result;
    }

    private void cacheService(String name, Class<?>[] argumentTypes, IService service) {
        Node currentNode = this.cache.get(name);
        if (currentNode == null) {
            currentNode = new Node();
            this.cache.put(name, currentNode);
        }
        Class<?>[] classArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            Node nextNode = (Node)currentNode.children.get(type);
            if (nextNode == null) {
                nextNode = new Node();
                currentNode.children.put(type, nextNode);
            }
            currentNode = nextNode;
            ++n2;
        }
        if (service == null) {
            currentNode.service = CacheLookupEngine.NO_SERVICE;
        } else {
            currentNode.service = service;
        }
    }

    private Node getNodeFromCache(String name, Class<?>[] argumentTypes) {
        Node result;
        Node currentNode = this.cache.get(name);
        if (currentNode != null) {
            Class<?>[] classArray = argumentTypes;
            int n = argumentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                if ((currentNode = (Node)currentNode.children.get(type)) == null) break;
                ++n2;
            }
            result = currentNode;
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Class<?> removeServices(Class<?> servicesClass) {
        this.cache.clear();
        return super.removeServices(servicesClass);
    }

    private static final class Node {
        private final Map<Class<?>, Node> children = new HashMap();
        private IService service;

        private Node() {
        }
    }
}

