/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.AbstractJavaType;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;

public class JavaMethodService
extends AbstractService {
    public static final int PRIORITY = 10;
    private final Method method;
    private final Object instance;

    public JavaMethodService(Method method, Object serviceInstance) {
        this.instance = serviceInstance;
        this.method = method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public List<IType> getParameterTypes(IReadOnlyQueryEnvironment queryEnvironment) {
        ArrayList<IType> result = new ArrayList<IType>();
        Class<?>[] classArray = this.method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            result.add(this.getClassType(queryEnvironment, cls));
            ++n2;
        }
        return result;
    }

    protected IJavaType getClassType(IReadOnlyQueryEnvironment queryEnvironment, Type type) {
        AbstractJavaType result;
        if (type instanceof ParameterizedType) {
            Class cls = (Class)((ParameterizedType)type).getRawType();
            if (List.class.isAssignableFrom(cls)) {
                IJavaType t = this.getClassType(queryEnvironment, ((ParameterizedType)type).getActualTypeArguments()[0]);
                result = new SequenceType(queryEnvironment, t);
            } else if (Set.class.isAssignableFrom(cls)) {
                IJavaType t = this.getClassType(queryEnvironment, ((ParameterizedType)type).getActualTypeArguments()[0]);
                result = new SetType(queryEnvironment, t);
            } else {
                result = new ClassType(queryEnvironment, cls);
            }
        } else if (type instanceof Class) {
            Class cls = (Class)type;
            result = new ClassType(queryEnvironment, cls);
        } else {
            result = new ClassType(queryEnvironment, Object.class);
        }
        return result;
    }

    @Override
    public int getNumberOfParameters() {
        return this.method.getParameterTypes().length;
    }

    @Override
    protected Object internalInvoke(Object[] arguments) throws Exception {
        return this.method.invoke(this.instance, arguments);
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        Type returnType = this.method.getGenericReturnType();
        result.addAll(services.getIType(returnType));
        return result;
    }

    @Override
    public boolean matches(IReadOnlyQueryEnvironment queryEnvironment, IType[] argumentTypes) {
        IType[] classTypes = this.getClassTypes(queryEnvironment, argumentTypes);
        return super.matches(queryEnvironment, classTypes);
    }

    protected ClassType[] getClassTypes(IReadOnlyQueryEnvironment queryEnvironment, IType[] iTypes) {
        ClassType[] result = new ClassType[iTypes.length];
        int i = 0;
        while (i < iTypes.length) {
            result[i] = new ClassType(queryEnvironment, this.getClass(queryEnvironment, iTypes[i]));
            ++i;
        }
        return result;
    }

    protected Class<?> getClass(IReadOnlyQueryEnvironment queryEnvironment, IType iType) {
        Class result;
        if (iType instanceof EClassifierLiteralType) {
            result = EClass.class;
        } else if (iType instanceof EClassifierType) {
            result = queryEnvironment.getEPackageProvider().getClass(((EClassifierType)iType).getType());
        } else if (iType instanceof IJavaType) {
            result = ((IJavaType)iType).getType();
        } else {
            throw new AcceleoQueryValidationException(iType.getClass().getCanonicalName());
        }
        if (result != null) {
            if ("boolean".equals(result.getName())) {
                result = Boolean.class;
            } else if ("int".equals(result.getName())) {
                result = Integer.class;
            } else if ("double".equals(result.getName())) {
                result = Double.class;
            }
        }
        return result;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    @Override
    public String getShortSignature() {
        return this.serviceShortSignature(this.method.getParameterTypes());
    }

    @Override
    public String getLongSignature() {
        return this.method.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaMethodService && ((JavaMethodService)obj).getMethod().equals(this.getMethod());
    }

    public int hashCode() {
        return this.getMethod().hashCode();
    }
}

