/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

public class Tester
extends PropertyTester {
    private static final String PROPERTY_NAME = "isDotnetProject";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals(PROPERTY_NAME)) {
            IResource resource = this.toResource(receiver);
            if (resource == null) {
                return false;
            }
            return Tester.isDotnetProject(resource.getProject());
        }
        return false;
    }

    private IResource toResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IAdaptable) {
            return (IResource)((IAdaptable)o).getAdapter(IResource.class);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDotnetProject(IProject p) {
        if (p == null) return false;
        if (!p.isAccessible()) {
            return false;
        }
        try {
            IResource[] iResourceArray = p.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource projItem = iResourceArray[n2];
                if (projItem.getName().equals("project.json")) return true;
                if (projItem.getName().matches("^.*\\.csproj$")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }
}

