/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.debug;

import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class AttachMainTab
extends AbstractLaunchConfigurationTab {
    static final String ATTR_PID = String.valueOf(AttachMainTab.class.getName()) + ".ATTR_PID";
    private Spinner pidText;

    public void createControl(Composite parent) {
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(3, false));
        Label pidLabel = new Label(res, 0);
        pidLabel.setText(Messages.AttachMainTab_processId);
        this.pidText = new Spinner(res, 2048);
        this.pidText.setMinimum(0);
        this.pidText.setMaximum(Integer.MAX_VALUE);
        this.pidText.setLayoutData((Object)new GridData(120, -1));
        this.pidText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.setControl((Control)res);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            if (configuration.hasAttribute(ATTR_PID)) {
                long pid = Long.parseLong(configuration.getAttribute(ATTR_PID, Integer.toString(-1)));
                if (pid >= Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("too big PID value: " + pid);
                }
                this.pidText.setSelection((int)pid);
            }
        }
        catch (NumberFormatException | CoreException e) {
            AcutePlugin.logError(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_PID, this.pidText.getText());
    }

    public String getName() {
        return Messages.AttachMainTab_title;
    }
}

