/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class CharactersEvent
extends DocumentBuilderEvent {
    private final String text;

    public CharactersEvent(String text) {
        this.text = (String)Preconditions.checkNotNull((Object)text, (Object)"Must provide text");
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.characters(this.text);
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.text});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharactersEvent)) {
            return false;
        }
        CharactersEvent other = (CharactersEvent)obj;
        return Objects.equal((Object)other.text, (Object)this.text);
    }

    public String toString() {
        return String.format("characters(\"%s\")", this.text);
    }
}

