/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.grammar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.Rule;

public class StackElement {
    public static final StackElement NULL = new StackElement(null, 0, 0, null, null, null);
    private int _enterPos;
    public final StackElement parent;
    public final int depth;
    public final int ruleId;
    public final String endRule;
    public final ScopeListElement nameScopesList;
    public final ScopeListElement contentNameScopesList;

    public StackElement(StackElement parent, int ruleId, int enterPos, String endRule, ScopeListElement nameScopesList, ScopeListElement contentNameScopesList) {
        this.parent = parent;
        this.depth = this.parent != null ? this.parent.depth + 1 : 1;
        this.ruleId = ruleId;
        this._enterPos = enterPos;
        this.endRule = endRule;
        this.nameScopesList = nameScopesList;
        this.contentNameScopesList = contentNameScopesList;
    }

    private static boolean _structuralEquals(StackElement a, StackElement b) {
        do {
            if (a == b) {
                return true;
            }
            if (a.depth != b.depth || a.ruleId != b.ruleId || a.endRule != b.endRule) {
                return false;
            }
            a = a.parent;
            b = b.parent;
            if (a != null || b != null) continue;
            return true;
        } while (a != null && b != null);
        return false;
    }

    private static boolean _equals(StackElement a, StackElement b) {
        if (a == b) {
            return true;
        }
        if (!StackElement._structuralEquals(a, b)) {
            return false;
        }
        return a.contentNameScopesList.equals(b.contentNameScopesList);
    }

    public StackElement clone() {
        return this;
    }

    public boolean equals(StackElement other) {
        if (other == null) {
            return false;
        }
        return StackElement._equals(this, other);
    }

    private static void _reset(StackElement el) {
        while (el != null) {
            el._enterPos = -1;
            el = el.parent;
        }
    }

    public void reset() {
        StackElement._reset(this);
    }

    public StackElement pop() {
        return this.parent;
    }

    public StackElement safePop() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    public StackElement push(int ruleId, int enterPos, String endRule, ScopeListElement nameScopesList, ScopeListElement contentNameScopesList) {
        return new StackElement(this, ruleId, enterPos, endRule, nameScopesList, contentNameScopesList);
    }

    public int getEnterPos() {
        return this._enterPos;
    }

    public Rule getRule(IRuleRegistry grammar) {
        return grammar.getRule(this.ruleId);
    }

    private void _writeString(List<String> res) {
        if (this.parent != null) {
            this.parent._writeString(res);
        }
        String s = "(" + this.ruleId + ")";
        res.add(s);
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>();
        this._writeString(r);
        return String.valueOf('[') + String.join((CharSequence)", ", r) + ']';
    }

    public StackElement setContentNameScopesList(ScopeListElement contentNameScopesList) {
        if (this.contentNameScopesList.equals(contentNameScopesList)) {
            return this;
        }
        return this.parent.push(this.ruleId, this._enterPos, this.endRule, this.nameScopesList, contentNameScopesList);
    }

    public StackElement setEndRule(String endRule) {
        if (this.endRule != null && this.endRule.equals(endRule)) {
            return this;
        }
        return new StackElement(this.parent, this.ruleId, this._enterPos, endRule, this.nameScopesList, this.contentNameScopesList);
    }

    public boolean hasSameRuleAs(StackElement other) {
        return this.ruleId == other.ruleId;
    }
}

