/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.composite.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.composite.internal.CompositeModelProducer;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class EclipseProjectCompositeModelProducer
implements CompositeModelProducer<EclipseProject> {
    private final Set<ProjectConnection> connections;

    public EclipseProjectCompositeModelProducer(Set<ProjectConnection> connections) {
        this.connections = connections;
    }

    @Override
    public Set<EclipseProject> getModel() {
        HashSet processedBuilds = Sets.newHashSet();
        HashSet eclipseProjects = Sets.newHashSet();
        for (ProjectConnection participant : this.connections) {
            EclipseProject rootProject = this.determineRootProject((EclipseProject)participant.getModel(EclipseProject.class));
            File rootProjectDirectory = rootProject.getProjectDirectory();
            if (!processedBuilds.add(rootProjectDirectory)) continue;
            this.addWithChildren(rootProject, eclipseProjects);
        }
        return Sets.newHashSet((Iterable)eclipseProjects);
    }

    private EclipseProject determineRootProject(EclipseProject eclipseProject) {
        if (eclipseProject.getParent() == null) {
            return eclipseProject;
        }
        return this.determineRootProject(eclipseProject.getParent());
    }

    private void addWithChildren(EclipseProject project, Set<EclipseProject> collectedProjects) {
        collectedProjects.add(project);
        for (EclipseProject childProject : project.getChildren()) {
            this.addWithChildren(childProject, collectedProjects);
        }
    }
}

