/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.Converter;
import java.util.Iterator;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.connection.ModelResult;
import org.gradle.tooling.connection.ModelResults;

final class ModelResultsConverter<T, U>
extends BaseConverter<ModelResults<T>, ModelResults<U>> {
    private final Converter<T, U> resultConverter;

    ModelResultsConverter(Converter<T, U> resultConverter) {
        this.resultConverter = resultConverter;
    }

    @Override
    public ModelResults<U> apply(ModelResults<T> input) {
        return new ConvertedModelResults(input);
    }

    private final class ConvertedModelResults
    implements ModelResults<U> {
        private final ModelResults<T> results;

        private ConvertedModelResults(ModelResults<T> input) {
            this.results = input;
        }

        public Iterator<ModelResult<U>> iterator() {
            return Iterators.transform((Iterator)this.results.iterator(), (Function)new Function<ModelResult<T>, ModelResult<U>>(){

                public ModelResult<U> apply(ModelResult<T> input) {
                    if (input.getFailure() == null) {
                        return new TransformedModelResult(input);
                    }
                    return input;
                }
            });
        }

        private final class TransformedModelResult
        implements ModelResult<U> {
            private final ModelResult<T> result;

            private TransformedModelResult(ModelResult<T> input) {
                this.result = input;
            }

            public U getModel() throws GradleConnectionException {
                return ModelResultsConverter.this.resultConverter.apply(this.result.getModel());
            }

            public GradleConnectionException getFailure() {
                return this.result.getFailure();
            }
        }
    }
}

