/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.nodeselection;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelectionProvider;
import org.eclipse.buildship.ui.util.nodeselection.SelectionSpecificAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public final class ActionEnablingSelectionChangedListener
implements ISelectionChangedListener {
    private final NodeSelectionProvider selectionProvider;
    private final ImmutableList<SelectionSpecificAction> actions;

    public ActionEnablingSelectionChangedListener(NodeSelectionProvider selectionProvider, List<? extends SelectionSpecificAction> actions) {
        this.selectionProvider = (NodeSelectionProvider)Preconditions.checkNotNull((Object)selectionProvider);
        this.actions = ImmutableList.copyOf(actions);
        this.handleSelection(this.selectionProvider.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.handleSelection(this.selectionProvider.getSelection());
    }

    private void handleSelection(NodeSelection selection) {
        for (SelectionSpecificAction action : this.actions) {
            action.setEnabledFor(selection);
        }
    }
}

